/************************************************************************/
/*									*/
/*  Layout of a table row in the document.				*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stddef.h>
#   include	<stdio.h>
#   include	<stdlib.h>

#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	"docPs.h"

#   include	<appDebugon.h>

/************************************************************************/
/*									*/
/*  Push the bottom of the row down.					*/
/*									*/
/************************************************************************/

void docPsLayoutPushBottomDown(		LayoutPosition *	lpRowBottom,
					const LayoutPosition *	lpColBottom )
    {
    if  ( lpRowBottom->lpPage < lpColBottom->lpPage )
	{
	lpRowBottom->lpPage= lpColBottom->lpPage;
	lpRowBottom->lpPageYTwips= lpColBottom->lpPageYTwips;
	lpRowBottom->lpAtTopOfColumn= lpColBottom->lpAtTopOfColumn;
	}
    else{
	if  ( lpRowBottom->lpPage == lpColBottom->lpPage )
	    {
	    if  ( lpRowBottom->lpPageYTwips < lpColBottom->lpPageYTwips )
		{
		lpRowBottom->lpPageYTwips= lpColBottom->lpPageYTwips;
		lpRowBottom->lpAtTopOfColumn= lpColBottom->lpAtTopOfColumn;
		}
	    }
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Layout as much of a table row as fits on the current page.		*/
/*									*/
/************************************************************************/

static int docPsLayoutRowPageStrip( BufferItem *		rowBi,
				int *				pToNextPage,
				int *				pAtTop,
				int *				pRowHeight,
				const ParagraphLayoutContext *	plc,
				ParagraphLayoutJob *		plj,
				AppDrawingData *		add,
				const BufferDocument *		bd,
				LayoutJob *			lj )
    {
    int				col;

    int				toNextPage= 0;

    int				atTop= 1;

    LayoutPosition		lpBottom;
    int				bottomTwips= -1;
    int				stripHigh= -1;
    const CellProperties *	cp;

    const ScreenLayout *	sl= &(plc->plcScreenLayout);

    lpBottom= lj->ljPosition;

    toNextPage= 0;

    if  ( rowBi->biRowHeightTwips < 0 )
	{
	bottomTwips= lj->ljPosition.lpPageYTwips-
				    rowBi->biRowHeightTwips- *pRowHeight;
	stripHigh= -rowBi->biRowHeightTwips;
	}

    cp= rowBi->biRowCells;
    for ( col= 0; col < rowBi->biChildCount; cp++, plj++, col++ )
	{
	BufferItem *			cellBi= rowBi->biChildren[col];
	ParagraphLayoutPosition *	plp= &(plj->pljPos);

	if  ( cp->cpMergedWithLeft )
	    { continue;	}

	if  ( plp->plpProgress.clpPara >= cellBi->biChildCount )
	    { continue;	}

	plp->plpPos= lj->ljPosition;

	docPsParagraphColumnFrame( sl, cellBi, add, bd,
						bottomTwips, stripHigh, plj );

	if  ( docPsLayoutParagraphsInStrip( plc, cellBi,
				add, bd, bottomTwips, stripHigh, plj ) )
	    { LDEB(1); return -1;	}

	if  ( plj->pljAdvanced )
	    { atTop= 0;	}

	docPsLayoutPushBottomDown( &lpBottom, &(plp->plpPos) );

	if  ( cellBi->biInHeaderFooter == DOCinBODY		&&
	      plp->plpProgress.clpPara < plj->pljParaUpto  	&&
	      ( bottomTwips < 0				||
	        plp->plpPos.lpPageYTwips < bottomTwips	)	)
	    { toNextPage= 1;	}
	}

    *pRowHeight += lpBottom.lpPageYTwips- lj->ljPosition.lpPageYTwips;

    lj->ljPosition= lpBottom;

    *pToNextPage= toNextPage;
    *pAtTop= atTop;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Calculate the layout of a row in the document.			*/
/*									*/
/************************************************************************/

static void docPsInitRowLayout(	BufferItem *			rowBi,
				const LayoutPosition *		lp,
				ParagraphLayoutJob *		plj )
    {
    CellProperties *		cp;
    int				col;

    cp= rowBi->biRowCells;
    for ( col= 0; col < rowBi->biChildCount; cp++, plj++, col++ )
	{
	BufferItem *	cellBi= rowBi->biChildren[col];

	docPsInitParagraphLayoutJob( plj );

	plj->pljParaUpto= cellBi->biChildCount;

	docPsBeginParagraphLayoutProgress( plj, 0, 0, 0,
						cellBi->biChildCount, lp );

	cellBi->biTopPosition= *lp;
	}

    return;
    }

static int docPsRowToNextPage(	BufferItem *			rowBi,
				AppDrawingData *		add,
				LayoutJob *			lj,
				const BufferDocument *		bd,
				int				bottomTwips,
				int				stripHigh,
				ParagraphLayoutJob *		rowPlj,
				const ParagraphLayoutContext *	plc )
    {
    CellProperties *		cp;
    int				col;

    ParagraphLayoutJob *	plj;

    const DocumentProperties *	dp= &(bd->bdProperties);

    LayoutPosition		lpBefore;

    lpBefore= lj->ljPosition;

    docPsToNextPage( rowBi, dp, add, &(lj->ljPosition) );

    cp= rowBi->biRowCells;
    plj= rowPlj;
    for ( col= 0; col < rowBi->biChildCount; cp++, plj++, col++ )
	{
	BufferItem *		cellBi= rowBi->biChildren[col];
	CellLayoutPosition	clp0;

	if  ( plj->pljPos.plpProgress.clpPara >= cellBi->biChildCount )
	    { continue;	}

	clp0= plj->pljPos0.plpProgress;

	docPsAdvanceParagraphLayout( &clp0, &(plj->pljPos.plpProgress),
						    lpBefore.lpPage, cellBi );

	if  ( clp0.clpPara >    plj->pljPos0.plpProgress.clpPara	||
	      ( clp0.clpPara == plj->pljPos0.plpProgress.clpPara &&
	        clp0.clpPart >  plj->pljPos0.plpProgress.clpPart )	)
	    {
	    plj->pljPos0.plpProgress= clp0;
	    plj->pljPos.plpProgress= clp0;
	    }
	else{ plj->pljPos0.plpProgress= plj->pljPos.plpProgress;	}
	}

    return 0;
    }

static void docPsLayoutFinishRow(	BufferItem *		rowBi,
					AppDrawingData *	add,
					LayoutJob *		lj,
					ParagraphLayoutJob *	plj )
    {
    int				col;
    CellProperties *		cp;

    double			xfac= add->addMagnifiedPixelsPerTwip;

    cp= rowBi->biRowCells;
    for ( col= 0; col < rowBi->biChildCount; cp++, plj++, col++ )
	{
	BufferItem *			cellBi= rowBi->biChildren[col];
	ParagraphLayoutPosition *	plp= &(plj->pljPos);

	if  ( cp->cpMergedWithLeft )
	    { continue;	}

	if  ( cp->cpBottomBorder.bpStyle != DOCbsNONE )
	    {
	    int		twips;
	    int		pixels;

	    twips= cp->cpBottomBorder.bpSpacingTwips;
	    /*  Word seems not to allocate this
	    twips += cp->cpBottomBorder.bpWidthTwips;
	    */
	    pixels= TWIPStoPIXELS( xfac, twips );

	    if  ( pixels == 0 )
		{ pixels= 1;	}

	    plp->plpPos.lpPageYTwips += twips;
	    plp->plpPos.lpAtTopOfColumn= 0;
	    }

	cellBi->biBelowPosition= plp->plpPos;

	docPsLayoutPushBottomDown( &(lj->ljPosition), &(plp->plpPos) );
	}

    return;
    }

int docPsLayoutRowItem(		BufferItem *			rowBi,
				AppDrawingData *		add,
				const BufferDocument *		bd,
				LayoutJob *			lj,
				const ParagraphLayoutContext *	plc )
    {
    const DocumentProperties *	dp= &(bd->bdProperties);

    int				rowHeightTwips;
    int				toNextPage;
    int				atTop;

    static ParagraphLayoutJob *	staticPlj;
    ParagraphLayoutJob *	fresh;

    int				bottomTwips= -1;

    const ScreenLayout *	sl= &(plc->plcScreenLayout);

    if  ( rowBi->biRowCellCount < rowBi->biChildCount )
	{
	LLDEB(rowBi->biRowCellCount,rowBi->biChildCount);
	docListItem( 0, rowBi );
	rowBi->biChildCount= rowBi->biRowCellCount;
	}

    fresh= (ParagraphLayoutJob *)realloc( staticPlj,
		    rowBi->biRowCellCount* sizeof(ParagraphLayoutJob) );
    if  ( ! fresh )
	{ LXDEB(rowBi->biRowCellCount,fresh); return -1;	}
    staticPlj= fresh;

    if  ( sl && sl->slStartRow			&&
	  (*sl->slStartRow)( rowBi, add, dp )	)
	{ LDEB(1); return -1;	}

    toNextPage= 0;
    rowHeightTwips= 0;
    if  ( rowBi->biRowHeightTwips < 0 )
	{ bottomTwips= lj->ljPosition.lpPageYTwips- rowBi->biRowHeightTwips; }

    docPsInitRowLayout( rowBi, &(lj->ljPosition), staticPlj );

    if  ( docPsLayoutRowPageStrip( rowBi, &toNextPage, &atTop,
			    &rowHeightTwips, plc, staticPlj, add, bd, lj ) )
	{ LDEB(1); return -1;	}

    if  ( toNextPage && rowBi->biRowKeepOnPage )
	{ atTop= 1;	}

    while( toNextPage )
	{
	if  ( docPsRowToNextPage( rowBi, add, lj, bd,
				bottomTwips, rowHeightTwips, staticPlj, plc ) )
	    { LDEB(toNextPage); return -1;	}

	if  ( atTop )
	    {
	    if  ( rowBi->biRowKeepOnPage )
		{ docPsInitRowLayout( rowBi, &(lj->ljPosition), staticPlj ); }

	    rowHeightTwips= 0;
	    if  ( rowBi->biRowHeightTwips < 0 )
		{
		bottomTwips=
			lj->ljPosition.lpPageYTwips- rowBi->biRowHeightTwips;
		}

	    rowBi->biTopPosition= lj->ljPosition;
	    }

	if  ( docPsLayoutRowPageStrip( rowBi, &toNextPage, &atTop,
			    &rowHeightTwips, plc, staticPlj, add, bd, lj ) )
	    { LDEB(1); return -1;	}

	atTop= 0;
	}

    docPsLayoutFinishRow( rowBi, add, lj, staticPlj );

    if  ( rowHeightTwips < rowBi->biRowHeightTwips )
	{
	lj->ljPosition.lpPageYTwips +=
				rowBi->biRowHeightTwips- rowHeightTwips;
	lj->ljPosition.lpAtTopOfColumn= 0;
	}

    if  ( rowHeightTwips < -rowBi->biRowHeightTwips )
	{
	lj->ljPosition.lpPageYTwips +=
				-rowBi->biRowHeightTwips- rowHeightTwips;
	lj->ljPosition.lpAtTopOfColumn= 0;
	}

    return 0;
    }

