/************************************************************************/
/*									*/
/*  Postscript printing and formatting related data structures.		*/
/*									*/
/************************************************************************/

#   include	<psFont.h>
#   include	"docBuf.h"
#   include	"docDraw.h"
#   include	"appPs.h"

/************************************************************************/
/*									*/
/*  Pixel position on a page						*/
/*									*/
/************************************************************************/

# define LP_YPIXELS( add, lp ) \
	    ( (add)->addPageStepPixels* (lp)->lpPage+ \
	      TWIPStoPIXELS( (add)->addMagnifiedPixelsPerTwip, \
						    (lp)->lpPageYTwips ) )

/**/

# define BI_TOP_PIXELS( add, bi ) \
			LP_YPIXELS( add, &((bi)->biTopPosition) )

# define BI_BELOW_PIXELS( add, bi ) \
			LP_YPIXELS( add, &((bi)->biBelowPosition) )

/**/

# define BP_TOP_PIXELS( add, bp ) \
			LP_YPIXELS( add, &((bp)->bpTopPosition) )

/**/

# define TL_TOP_PIXELS( add, tl ) LP_YPIXELS( add, &((tl)->tlTopPosition) )

# define TL_BASE_PIXELS( add, tl ) \
	    ( (add)->addPageStepPixels* (tl)->tlTopPosition.lpPage+ \
	      TWIPStoPIXELS( (add)->addMagnifiedPixelsPerTwip, \
		(tl)->tlTopPosition.lpPageYTwips+ (tl)->tlLineAscentTwips ) )

# define TL_BELOW_PIXELS( add, tl ) \
	    ( (add)->addPageStepPixels* (tl)->tlTopPosition.lpPage+ \
	      TWIPStoPIXELS( (add)->addMagnifiedPixelsPerTwip, \
		(tl)->tlTopPosition.lpPageYTwips+ (tl)->tlLineSpacingTwips ) )

/************************************************************************/
/*									*/
/*  Additional information for the layout of a line of text. Some of	*/
/*  the sfields are used for scratch in the process.			*/
/*									*/
/************************************************************************/

typedef struct ParticuleData
    {
    int			pdX0;
    int			pdWidth;
    int			pdDecWidth;
    int			pdVisibleWidth;
    int			pdTabNumber;
    int			pdTabKind;
    int			pdTabPosition;
    const AfmFontInfo *	pdAfi;

    int			pdVisiblePixels;
    int			pdWhiteUnits;
    int			pdCorrectBy;
    } ParticuleData;

/************************************************************************/
/*									*/
/*  Pass through information for a layout job.				*/
/*									*/
/************************************************************************/

typedef int (*LAYOUT_SCREEN_LINE)( TextLine *			tl,
				const BufferItem *		bi,
				int				part,
				int				accepted,
				AppDrawingData *		add,
				const FormattingFrame *		ffPixels,
				TextParticule *			tp,
				ParticuleData *			pd );

typedef int (*START_PARAGRAPH)(	BufferItem *			bi,
				AppDrawingData *		add,
				const DocumentProperties *	dp );

typedef void (*SCREEN_FRAME)(	FormattingFrame *		ff,
				const AppDrawingData *		add,
				const BufferItem *		bi );

typedef int (*START_SCREEN_PARAGRAPH)(
				BufferItem *			bi,
				AppDrawingData *		add,
				const DocumentProperties *	dp );

typedef int (*START_ROW)(	BufferItem *			rowBi,
				AppDrawingData *		add,
				const DocumentProperties *	dp );

typedef struct ScreenLayout
    {
    START_ROW			slStartRow;
    START_SCREEN_PARAGRAPH	slStartParagraph;
    SCREEN_FRAME		slScreenFrame;
    LAYOUT_SCREEN_LINE		slLayoutLine;
    } ScreenLayout;

typedef struct LayoutJob
    {
    LayoutPosition		ljPosition;
    LayoutPosition		ljBottom;

    DocumentRectangle *		ljChangedRectanglePixels;

    ScreenLayout		ljLayoutScreen;
    ScreenLayout		ljPlaceScreen;
    } LayoutJob;

/************************************************************************/
/*									*/
/*  For formatting a series of paragraphs. ( Inside a Cell or just	*/
/*  below eachother )							*/
/*									*/
/************************************************************************/

typedef struct CellLayoutPosition
    {
    int			clpPara;
    int			clpPart;
    int			clpLine;
    } CellLayoutPosition;

typedef struct ParagraphLayoutPosition
    {
    CellLayoutPosition	plpProgress;
    LayoutPosition	plpPos;
    FormattingFrame	plpFormattingFrame;
    } ParagraphLayoutPosition;

typedef struct ParagraphLayoutJob
    {
    int				pljAdvanced;
    int				pljParaUpto;

    ParagraphLayoutPosition	pljPos;
    ParagraphLayoutPosition	pljPos0;
    } ParagraphLayoutJob;

struct ParagraphLayoutContext;

typedef int (*LAYOUT_LINES)(
			const struct ParagraphLayoutContext *	plc,
			BufferItem *				bi,
			int					part,
			AppDrawingData *			add,
			const BufferDocument *			bd,
			const FormattingFrame *			ff,
			int *					pLinesDone,
			const LayoutPosition *			lpTop,
			LayoutPosition *			lpBottom );

typedef void (*ADJUST_BOTTOM)(		int *			pChanged,
					BufferItem *		bi,
					const LayoutPosition *	lp,
					AppDrawingData *	add,
					DocumentRectangle *	drChanged );

typedef struct ParagraphLayoutContext
    {
    DocumentRectangle *		plcChangedRectanglePixels;

    ScreenLayout		plcScreenLayout;
    START_PARAGRAPH		plcStartParagraph;
    LAYOUT_LINES		plcLayoutLines;
    ADJUST_BOTTOM		plcAdjustBottom;
    } ParagraphLayoutContext;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int docPsLineBox(	TextLine *			tl,
				const BufferItem *		bi,
				int				part,
				int				tabInterval,
				const DocumentFontList *	dfl,
				AppPhysicalFontList *		apfl,
				const TextParticule *		tp,
				ParticuleData *			pd,
				const FormattingFrame *		ff );

extern AfmFontInfo * docPsPrintGetAfi(	const AppPhysicalFontList *	apfl,
					int				physf );

extern int docPsClaimParticuleData(	const BufferItem *	bi,
					ParticuleData **	pData );

extern int docPsParagraphLineExtents(	const AppPhysicalFontList *	apfl,
					BufferItem *			bi );

extern int docPsPrintGetItemFonts(	const BufferItem *		bi,
					DocumentFontList *		dfl,
					const AppPhysicalFontList *	apfl,
					PostScriptFont **		pFntLst,
					int *				pCount );

extern int docPsPrintDocument(	FILE *			f,
			const char *			title,
			const char *			applicationName,
			const char *			applicationReference,
			AppDrawingData *		add,
			BufferDocument *		bd,
			int				nup,
			int				horizontal,
			int				firstPage,
			int				lastPage,
			const DocumentGeometry *	dgPrinter,
			LAYOUT_EXTERNAL			layoutExternal,
			DOC_CLOSE_OBJECT		closeObject );

extern int docPsLayoutItemAndParents(	BufferItem *		bi,
					AppDrawingData *	add,
					const BufferDocument *	bd,
					LayoutJob *		lj,
					int			andParents );

extern int docPsAdjustParaLayout(	BufferItem *		bi,
					int			line,
					int			stroffShift,
					int			upto,
					AppDrawingData *	add,
					const BufferDocument *	bd,
					LayoutJob *		lj );

extern void docPsStartPageLayout( int				page,
				BufferItem *			sectBi,
				const DocumentProperties *	dp,
				AppDrawingData *		add,
				LayoutPosition *		lpTop );

extern int docPsListObjectFonts(	const InsertedObject *	io,
					const char *		afmDirectory,
					const char *		prefix,
					PostScriptFont **	pFontList,
					int *			pCount );

extern int docLayoutHeaderFooter( HeaderFooter *		hf,
				int				pageNumber,
				BufferDocument *		bd,
				const BufferItem *		sectBi,
				AppDrawingData *		add,
				LAYOUT_EXTERNAL			layoutExternal,
				DocumentRectangle *		drChanged,
				DOC_CLOSE_OBJECT		closeObject );

extern int docPsLayoutParagraphsInStrip(
				const ParagraphLayoutContext *	plc,
				BufferItem *			cellBi,
				AppDrawingData *		add,
				const BufferDocument *		bd,
				int				bottomTwips,
				int				stripHigh,
				ParagraphLayoutJob *		plj );

extern int docPsLayoutParagraphs(
				const ParagraphLayoutContext *	plc,
				BufferItem *			cellBi,
				AppDrawingData *		add,
				const BufferDocument *		bd,
				ParagraphLayoutJob *		plj );

extern void docPsInitParagraphLayoutJob( ParagraphLayoutJob *	plj );

extern void docPsToNextPage(	BufferItem *			bi,
				const DocumentProperties *	dp,
				AppDrawingData *		add,
				LayoutPosition *		lpTop );

extern void docPsBeginParagraphLayoutProgress(	ParagraphLayoutJob *	plj,
						int			para,
						int			line,
						int			part,
						int			pUpto,
						const LayoutPosition *	lp );

extern int docPsLayoutRowItem(	BufferItem *			rowBi,
				AppDrawingData *		add,
				const BufferDocument *		bd,
				LayoutJob *			lj,
				const ParagraphLayoutContext *	plc );

extern void docPsLayoutPushBottomDown(	LayoutPosition *	lpRowBottom,
					const LayoutPosition *	lpColBottom );

extern void docParagraphFrameTwips(
				FormattingFrame *		ff,
				int				bottom,
				int				stripHigh,
				const BufferItem *		bi,
				const DocumentProperties *	dp,
				int				page,
				int				column );

extern void docPsAdvanceParagraphLayout(
				CellLayoutPosition *		clp0,
				const CellLayoutPosition *	clp1,
				int				page,
				const BufferItem *		cellBi );

extern void docPsParagraphColumnFrame(
				const ScreenLayout *		sl,
				const BufferItem *		cellBi,
				AppDrawingData *		add,
				const BufferDocument *		bd,
				int				bottomTwips,
				int				stripHigh,
				ParagraphLayoutJob *		plj );

