/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Initialise a BufferItem.						*/
/*									*/
/************************************************************************/

void docInitCellProperties(	CellProperties *	cp )
    {
    cp->cpRightBoundaryTwips= 0;
    cp->cpRightBoundaryPixels= 0;

    cp->cpForegroundColor= -1;
    cp->cpBackgroundColor= -1;

    cp->cpShadingLevel= 0;
    cp->cpShadingPattern= DOCspSOLID;

    cp->cpLeftInMergedRow= 0;
    cp->cpMergedWithLeft= 0;
    cp->cpTopInMergedColumn= 0;
    cp->cpMergedWithAbove= 0;

    cp->cpVerticalTextAlignment= DOCvtaTOP;

    docInitBorderProperties( &(cp->cpTopBorder) );
    docInitBorderProperties( &(cp->cpLeftBorder) );
    docInitBorderProperties( &(cp->cpRightBorder) );
    docInitBorderProperties( &(cp->cpBottomBorder) );
    }

void docCleanInitRowProperties(	RowProperties *	rp )
    {
    docCleanRowProperties( rp );
    docInitRowProperties( rp );
    }

void docCleanRowProperties(	RowProperties *	rp )
    {
    if  ( rp->rpCells )
	{ free( rp->rpCells );	}
    }

void docInitRowProperties(	RowProperties *	rp )
    {
    rp->rpCellCount= 0;
    rp->rpCells= (CellProperties *)0;

    rp->rpHalfGapWidthTwips= 0;
    rp->rpHalfGapWidthPixels= 0;

    rp->rpHeightTwips= 0;

    rp->rpLeftIndentTwips= 0;
    rp->rpLeftIndentPixels= 0;

    rp->rpHasTableParagraphs= 0;

    rp->rpIsTableHeader= 0;
    rp->rpKeepOnPage= 0;

    rp->rpHasHorizontalBorders= 0;
    rp->rpHasVerticalBorders= 0;

    docInitBorderProperties( &rp->rpTopBorder );
    docInitBorderProperties( &rp->rpBottomBorder );
    docInitBorderProperties( &rp->rpLeftBorder );
    docInitBorderProperties( &rp->rpRightBorder );
    docInitBorderProperties( &rp->rpHorizontalBorder );
    docInitBorderProperties( &rp->rpVerticalBorder );
    }

int docInsertRowColumn(	RowProperties *			rp,
			int				n,
			const CellProperties *		cp )
    {
    CellProperties *	fresh;

    fresh= (CellProperties *)realloc( rp->rpCells,
			(rp->rpCellCount+ 1)* sizeof(CellProperties) );
    if  ( ! fresh )
	{ LXDEB(rp->rpCellCount,fresh); return -1;	}
    rp->rpCells= fresh;

    if  ( n < 0 )
	{ n= rp->rpCellCount;	}
    else{
	int		i;

	for ( i= rp->rpCellCount; i > n; i-- )
	    { fresh[i]= fresh[i-1];	}
	}

    fresh[n]= *cp;
    rp->rpCellCount++;

    return 0;
    }

int docCopyRowProperties(	RowProperties *		to,
				const RowProperties *	from	)
    {
    CellProperties *	cp= (CellProperties *)0;

    if  ( from->rpCellCount > 0 )
	{
	int	i;

	cp= (CellProperties *)realloc( to->rpCells,
			    from->rpCellCount* sizeof(CellProperties) );
	if  ( ! cp )
	    { LXDEB(from->rpCellCount,cp); return -1;	}

	for ( i= 0; i < from->rpCellCount; i++ )
	    { cp[i]= from->rpCells[i];	}
	}

    *to= *from; to->rpCells= cp;

    return 0;
    }


/************************************************************************/
/*									*/
/*  1) Are the columns in two RowProperties 'the same' (Do they align?)	*/
/*  2) All column properties identical?					*/
/*									*/
/************************************************************************/

int docAlignedColumns(	const RowProperties *	rp1,
			const RowProperties *	rp2 )
    {
    CellProperties *	cp1;
    CellProperties *	cp2;
    int			i;

    if  ( rp1->rpHasTableParagraphs != rp2->rpHasTableParagraphs )
	{ return 0;	}

    if  ( rp1->rpCellCount != rp2->rpCellCount )
	{ return 0;	}

    if  ( rp1->rpHalfGapWidthTwips != rp2->rpHalfGapWidthTwips )
	{ return 0;	}

    if  ( rp1->rpLeftIndentTwips != rp2->rpLeftIndentTwips )
	{ return 0;	}

    cp1= rp1->rpCells;
    cp2= rp2->rpCells;
    for ( i= 0; i < rp1->rpCellCount; cp2++, cp1++, i++ )
	{
	if  ( cp1->cpRightBoundaryTwips != cp2->cpRightBoundaryTwips )
	    { return 0;	}
	}

    return 1;
    }

int docEqualRows(	const RowProperties *	rp1,
			const RowProperties *	rp2 )
    {
    const CellProperties *	cp1;
    const CellProperties *	cp2;
    int				i;

    if  ( rp1->rpCellCount != rp2->rpCellCount )
	{ return 0;	}

    if  ( rp1->rpHalfGapWidthTwips != rp2->rpHalfGapWidthTwips )
	{ return 0;	}

    if  ( rp1->rpLeftIndentTwips != rp2->rpLeftIndentTwips )
	{ return 0;	}

    if  ( rp1->rpHeightTwips != rp2->rpHeightTwips )
	{ return 0;	}

    if  ( rp1->rpIsTableHeader != rp2->rpIsTableHeader )
	{ return 0;	}

    if  ( rp1->rpHasVerticalBorders != rp2->rpHasVerticalBorders )
	{ return 0;	}
    if  ( rp1->rpHasHorizontalBorders != rp2->rpHasHorizontalBorders )
	{ return 0;	}

    if  ( docBorderPropertyDifference( &rp1->rpTopBorder,
				&rp2->rpTopBorder, BRDRupdALL )	)
	{ return 0;	}
    if  ( docBorderPropertyDifference( &rp1->rpLeftBorder,
				&rp2->rpLeftBorder, BRDRupdALL ) )
	{ return 0;	}
    if  ( docBorderPropertyDifference( &rp1->rpRightBorder,
				&rp2->rpRightBorder, BRDRupdALL ) )
	{ return 0;	}
    if  ( docBorderPropertyDifference( &rp1->rpBottomBorder,
				&rp2->rpBottomBorder, BRDRupdALL ) )
	{ return 0;	}
    if  ( rp1->rpHasVerticalBorders					&&
	  docBorderPropertyDifference( &rp1->rpVerticalBorder,
				&rp2->rpVerticalBorder, BRDRupdALL )	)
	{ return 0;	}
    if  ( rp1->rpHasHorizontalBorders					&&
	  docBorderPropertyDifference( &rp1->rpHorizontalBorder,
				&rp2->rpHorizontalBorder, BRDRupdALL )	)
	{ return 0;	}

    cp1= rp1->rpCells;
    cp2= rp2->rpCells;
    for ( i= 0; i < rp1->rpCellCount; cp2++, cp1++, i++ )
	{
	if  ( cp1->cpRightBoundaryTwips != cp2->cpRightBoundaryTwips )
	    { return 0;	}
	if  ( cp1->cpLeftInMergedRow != cp2->cpLeftInMergedRow )
	    { return 0;	}
	if  ( cp1->cpMergedWithLeft != cp2->cpMergedWithLeft )
	    { return 0;	}

	if  ( docBorderPropertyDifference( &cp1->cpTopBorder,
				    &(cp2->cpTopBorder), BRDRupdALL ) )
	    { return 0;	}
	if  ( docBorderPropertyDifference( &cp1->cpLeftBorder,
				    &(cp2->cpLeftBorder), BRDRupdALL ) )
	    { return 0;	}
	if  ( docBorderPropertyDifference( &cp1->cpRightBorder,
				    &(cp2->cpRightBorder), BRDRupdALL ) )
	    { return 0;	}
	if  ( docBorderPropertyDifference( &cp1->cpBottomBorder,
				    &(cp2->cpBottomBorder), BRDRupdALL ) )
	    { return 0;	}
	}

    return 1;
    }

void docInitTabStop(	TabStop *	ts )
    {
    ts->tsTwips= 0;
    ts->tsPixels= 0;
    ts->tsKind= DOCtkLEFT;
    ts->tsLeader= DOCtlNONE;
    }

/************************************************************************/
/*									*/
/*  Statistics about a document. Used in the 'Document Properties'	*/
/*  dialog.								*/
/*									*/
/************************************************************************/

void docInitDocumentStatistics(		DocumentStatistics *	ds )
    {
    ds->dsPageCount= 0;
    ds->dsParagraphCount= 0;
    ds->dsLineCount= 0;
    ds->dsWordCount= 0;
    ds->dsCharacterCount= 0;

    return;
    }

/************************************************************************/
/*									*/
/*  Paragraph numbering.						*/
/*									*/
/************************************************************************/

void docInitParagraphNumber(	ParagraphNumber*	pn )
    {
    pn->pnLevel= -1;
    pn->pnStyle= DOCpnDEC;

    pn->pnUseHangingIndent= 0;

    pn->pnStartNumber= 0;
    pn->pnIndentTwips= 0;

    docInitTextAttribute( &(pn->pnTextAttribute) );

    pn->pnTextBefore[0]= '\0';
    pn->pnTextAfter[0]= '\0';

    return;
    }

/************************************************************************/
/*									*/
/*  Merge the font list of one document into that of another one.	*/
/*  Update the references accordingly.					*/
/*									*/
/************************************************************************/

int docMergeDocumentFontsIntoList(	DocumentFontList *	dflTo,
					BufferDocument *	bdFrom )
    {
    BufferPosition		bpBeginFrom;
    BufferItem *		bi;

    int *			fontMap= (int *)0;
    int *			fontUsed= (int *)0;

    int				fromFont;
    int				fromFontCount;
    DocumentFont *		fromFonts;

    int				toFont;
    int				toFontCount;
    DocumentFont *		toFonts;

    fromFontCount= bdFrom->bdProperties.dpFontList.dflCount;
    fromFonts= bdFrom->bdProperties.dpFontList.dflFonts;

    toFontCount= dflTo->dflCount;
    toFonts= dflTo->dflFonts;

    toFonts= (DocumentFont *)realloc( toFonts,
		    ( toFontCount+ fromFontCount )* sizeof(DocumentFont) );
    if  ( ! toFonts )
	{ LXDEB(toFontCount+ fromFontCount,toFonts); return -1;	}
    dflTo->dflFonts= toFonts;

    fontMap= (int *)malloc( fromFontCount* sizeof( int ) );
    if  ( ! fontMap )
	{ LXDEB(fromFontCount,fontMap); return -1; }

    fontUsed= (int *)malloc( fromFontCount* sizeof( int ) );
    if  ( ! fontUsed )
	{ LXDEB(fromFontCount,fontUsed); return -1; }

    for ( fromFont= 0; fromFont < fromFontCount; fromFont++ )
	{ fontUsed[fromFont]= 0;	}

    if  ( docFirstPosition( &(bdFrom->bdItem), &bpBeginFrom ) )
	{ LDEB(1); return -1;	}
    bi= bpBeginFrom.bpBi;

    for (;;)
	{
	TextParticule *		tp;
	int			part;

	tp= bi->biParaParticules;

	for ( part= 0; part < bi->biParaParticuleCount; part++, tp++ )
	    { fontUsed[tp->tpTextAttribute.taFontNumber]= 1; }

	bi= docNextParagraph( bi );
	if  ( ! bi )
	    { break;	}
	}

    for ( fromFont= 0; fromFont < fromFontCount; fromFont++ )
	{
	if  ( ! fontUsed[fromFont] )
	    { continue;	}

	for ( toFont= 0; toFont < toFontCount; toFont++ )
	    {
	    if  ( toFonts[toFont].dfDocFamilyNumber < 0 )
		{ continue;	} 

	    if  ( ! toFonts[toFont].dfFamilyStyle )
		{ XDEB(toFonts[toFont].dfFamilyStyle); continue;	}

	    if  ( ! strcmp( fromFonts[fromFont].dfFamilyStyle,
					toFonts[toFont].dfFamilyStyle )	&&
		  ! strcmp( fromFonts[fromFont].dfName,
					toFonts[toFont].dfName )	)
		{ break;	}
	    }

	if  ( toFont >= toFontCount )
	    {
	    DocumentFont *	df;

	    df= docInsertFont( dflTo,
				    -1,
				    fromFonts[fromFont].dfFamilyStyle,
				    fromFonts[fromFont].dfName );

	    if  ( ! df )
		{ XDEB(df); return -1;	}

	    toFont= df->dfDocFamilyNumber;

	    toFonts= dflTo->dflFonts;
	    toFontCount= dflTo->dflCount;
	    }

	fontMap[fromFont]= toFont;
	}

    if  ( docFirstPosition( &(bdFrom->bdItem), &bpBeginFrom ) )
	{ LDEB(1); return -1;	}
    bi= bpBeginFrom.bpBi;

    for (;;)
	{
	TextParticule *		tp;
	int			part;

	tp= bi->biParaParticules;

	for ( part= 0; part < bi->biParaParticuleCount; part++, tp++ )
	    {
	    if  ( tp->tpTextAttribute.taFontNumber < 0			||
		  tp->tpTextAttribute.taFontNumber >= fromFontCount	)
		{
		LDEB(part);
		LLDEB(tp->tpTextAttribute.taFontNumber,fromFontCount);
		tp->tpTextAttribute.taFontNumber= 0;
		}
	    tp->tpTextAttribute.taFontNumber=
				    fontMap[tp->tpTextAttribute.taFontNumber];
	    }

	bi= docNextParagraph( bi );
	if  ( ! bi )
	    { break;	}
	}

    if  ( fontMap )
	{ free( fontMap );	}
    if  ( fontUsed )
	{ free( fontUsed );	}

    return 0;
    }
