/************************************************************************/
/*									*/
/*  Paragraph properties.						*/
/*									*/
/************************************************************************/

#   ifndef	DOC_PARA_PROP_H
#   define	DOC_PARA_PROP_H

#   include	<docFont.h>
#   include	"utilPropMask.h"
#   include	"docPropVal.h"
#   include	"docBorderProperties.h"
#   include	"docParaNumber.h"
#   include	"docFrameProperties.h"

/************************************************************************/
/*									*/
/*  Describes tabs.							*/
/*									*/
/*  !)	RS6000/AIX compler only supports unsigned bitfields.		*/
/*									*/
/************************************************************************/

typedef enum TabKind
    {
    DOCtkLEFT= 0,

    DOCtkRIGHT,
    DOCtkCENTRE,
    DOCtkDECIMAL
    } TabKind;

typedef enum TabLeader
    {
    DOCtlNONE= 0,

    DOCtlDOTS,
    DOCtlHYPH,
    DOCtlUNDERLINE,
    DOCtlTHICK,
    DOCtlEQUAL
    } TabLeader;

typedef struct TabStop
    {
    int			tsTwips;
    int			tsPixels;
    unsigned int	tsKind:2;	/*  (enum)	*/
    unsigned int	tsLeader:3;	/*  (enum)	*/
    } TabStop;

/************************************************************************/
/*									*/
/*  Paragraph properties.						*/
/*									*/
/*  Unless explicitly stated, all properties except numbers in pixels	*/
/*  are properties of the paragraph.					*/
/*									*/
/*  1)  Tab stops.							*/
/*  2)  Indentations.							*/
/*  3)  White space above/after the paragraph.				*/
/*  4)  Style.								*/
/*  5)  Borders.							*/
/*									*/
/************************************************************************/

typedef struct ParagraphProperties
    {
    /*  1  */
    TabStop *		ppTabStops;
    short int		ppTabCount;

    /*  2  */
    short int		ppFirstIndentTwips;
    short int		ppLeftIndentTwips;
    short int		ppRightIndentTwips;

    /*  3  */
    short int		ppSpaceBeforeTwips;
    short int		ppSpaceAfterTwips;
    short int		ppLineSpacingTwips;

    /*  4  */
    short int		ppStyle;

    /*  5  */
    BorderProperties	ppTopBorder;
    BorderProperties	ppBottomBorder;
    BorderProperties	ppLeftBorder;
    BorderProperties	ppRightBorder;
    BorderProperties	ppBetweenBorder;
    BorderProperties	ppBoxBorder;
    BorderProperties	ppBar;

    unsigned int	ppOutlineLevel:4;

    unsigned int	ppShadingLevel:10;
    unsigned int	ppShadingPattern:4;		/*  (enum)	*/

    unsigned int	ppAlignment:3;			/*  (enum)	*/

    unsigned int	ppStartsOnNewPage:1;
    unsigned int	ppInTable:1;
    unsigned int	ppLineSpacingIsMultiple:1;

    unsigned int	ppKeepOnPage:1;
    unsigned int	ppKeepWithNext:1;
    unsigned int	ppWidowControl:1;
    unsigned int	ppHyphenateParagraph:1;

    short int		ppShadingForeground;
    short int		ppShadingBackground;
    } ParagraphProperties;

/************************************************************************/
/*									*/
/*  Numbers and Masks for updating paragraph properies.			*/
/*									*/
/************************************************************************/

typedef enum ParagraphProperty
    {
    PPprop_NONE= -1,

    PPpropSTYLE= 0,
    PPpropLEFT_INDENT,
    PPpropFIRST_INDENT,
    PPpropRIGHT_INDENT,
    PPpropALIGNMENT,
    PPpropTAB_STOPS,
    PPpropNEWPAGE,
    PPpropWIDCTLPAR,
    PPpropKEEP,
    PPpropKEEPN,
    PPpropSPACE_BEFORE,
    PPpropSPACE_AFTER,
    PPpropLINE_SPACING_DIST,
    PPpropLINE_SPACING_MULT,
    PPpropTOP_BORDER,
    PPpropBOTTOM_BORDER,
    PPpropOUTLINELEVEL,
    PPpropHYPHPAR,
    PPpropSHADING_LEVEL,
    PPpropSHADING_PATTERN,
    PPpropSHADING_FOREGROUND,
    PPpropSHADING_BACKGROUND,

    PPpropCOLUMNS,			/*  Not a real property.	*/

    PPprop_COUNT
    } ParagraphProperty;

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int docUpdParaProperties( unsigned int *			pPpChgPask,
				ParagraphProperties *		pp,
				unsigned int			ppUpdMask,
				const ParagraphProperties *	ppNew );

extern unsigned int docParaPropertyDifference(
				const ParagraphProperties *	pp1,
				const ParagraphProperties *	pp2,
				unsigned int			updMask );

extern void docCleanParagraphProperties(	ParagraphProperties *	pp );

extern void docInitParagraphProperties(		ParagraphProperties *	pp );

extern int docCopyParagraphProperties(	ParagraphProperties *		to,
					const ParagraphProperties *	from );

#   endif	/*  DOC_PARA_PROP_H	*/
