/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Evaluate page number related fields.				*/
/*									*/
/*  The function that evaluates a REF field is an honorary member of	*/
/*  this file.								*/
/*									*/
/************************************************************************/

/************************************************************************/
/*									*/
/*  Format a page number to be used in a certain paragraph.		*/
/*									*/
/************************************************************************/

static int docGetPageNumberOffset(	const BufferItem *	sectBi )
    {
    if  ( ! sectBi->biParent )
	{ XDEB(sectBi->biParent); return 0;	}

    while( sectBi->biNumberInParent > 0 )
	{
	if  ( sectBi->biSectRestartPageNumbers )
	    { break;	}

	sectBi= sectBi->biParent->biChildren[sectBi->biNumberInParent- 1];
	}

    if  ( sectBi->biSectRestartPageNumbers )
	{
	return sectBi->biTopPosition.lpPage- sectBi->biSectStartPageNumber;
	}
    else{ return sectBi->biTopPosition.lpPage; }
    }

static void docFormatPageNumber(	char *			target,
					int			targetSize,
					const BufferItem *	sectBi,
					int			pageNumber )
    {
    int			style= sectBi->biSectPageNumberStyle;

    if  ( targetSize < 20 )
	{ LDEB(targetSize); strcpy( target, "?" ); return;	}

    pageNumber -= docGetPageNumberOffset( sectBi );

    switch( style )
	{
	default:
	    LDEB(style);
	    /*FALLTHROUGH*/

	case DOCpgnDEC:
	    sprintf( target, "%d", pageNumber+ 1 );
	    break;

	case DOCpgnUCLTR:
	    if  ( pageNumber >= 0 && pageNumber <= 26 )
		{ target[0]= 'A'+ pageNumber; target[1]= '\0';	}
	    else{ sprintf( target, "UCLTR:%d", pageNumber+ 1 );	}
	    break;

	case DOCpgnLCLTR:
	    if  ( pageNumber >= 0 && pageNumber <= 26 )
		{ target[0]= 'a'+ pageNumber; target[1]= '\0';	}
	    else{ sprintf( target, "lcltr:%d", pageNumber+ 1 );	}
	    break;

	case DOCpgnUCRM:
	    if  ( appRomanString( target, targetSize, pageNumber+ 1, 1 ) )
		{ sprintf( target, "UCRM:%d", pageNumber+ 1 );	}
	    break;

	case DOCpgnLCRM:
	    if  ( appRomanString( target, targetSize, pageNumber+ 1, 0 ) )
		{ sprintf( target, "lcrm:%d", pageNumber+ 1 );	}
	    break;
	}

    return;
    }

/************************************************************************/
/*									*/
/*  Return the value of a pageref field.				*/
/*									*/
/************************************************************************/

int docCalculatePagerefFieldString(	int *			pCalculated,
					int *			pNewSize,
					unsigned char *		target,
					int			targetSize,
					BufferDocument *	bd,
					const BufferItem *	paraBi,
					const DocumentField *	dfRef )
    {
    const DocumentField *	dfMark;
    int				pageNumber;
    int				i;
    const BufferItem *		sectBi= (const BufferItem *)0;

    const char *		markName;
    int				markSize;

    if  ( docFieldGetPageref( dfRef, &markName, &markSize ) )
	{ LDEB(1); *pCalculated= 0; return 0;	}

    dfMark= docFindBookmarkField( &(bd->bdFieldList), markName, markSize );
    if  ( ! dfMark )
	{ SXDEB(markName,dfMark); *pCalculated= 0; return 0;	}

    pageNumber= dfMark->dfPage;

    for ( i= 0; i < bd->bdItem.biChildCount; i++ )
	{
	sectBi= bd->bdItem.biChildren[i];
	if  ( sectBi->biBelowPosition.lpPage >= pageNumber )
	    { break;	}
	}

    if  ( i >= bd->bdItem.biChildCount )
	{ LDEB(1); *pCalculated= 0; return 0;	}

    docFormatPageNumber( (char *)target, targetSize, sectBi, pageNumber );

    *pNewSize= strlen( (char *)target );
    *pCalculated= 1;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Return the value of a page/numpages field.				*/
/*									*/
/************************************************************************/

int docCalculatePageFieldString(	int *			pCalculated,
					int *			pNewSize,
					unsigned char *		target,
					int			targetSize,
					BufferDocument *	bd,
					const BufferItem *	paraBi,
					const DocumentField *	df )
    {
    const BufferItem *	headerFooterBi;

    headerFooterBi= paraBi->biParent;
    headerFooterBi= headerFooterBi->biParent;
    headerFooterBi= headerFooterBi->biParent;

    docFormatPageNumber( (char *)target, targetSize,
			    headerFooterBi->biSectHeaderFooterUseForSectBi,
			    headerFooterBi->biSectHeaderFooterUseForPage );
    *pNewSize= strlen( (char *)target );

    *pCalculated= 1; return 0;
    }

int docCalculateNumpagesFieldString(	int *			pCalculated,
					int *			pNewSize,
					unsigned char *		target,
					int			targetSize,
					BufferDocument *	bd,
					const BufferItem *	paraBi,
					const DocumentField *	df )
    {
    if  ( targetSize < 20 )
	{ LDEB(targetSize); return -1;	}

    sprintf( (char *)target, "%d", bd->bdItem.biBelowPosition.lpPage );
    *pNewSize= strlen( (char *)target );

    *pCalculated= 1; return 0;
    }

/************************************************************************/
/*									*/
/*  Return the value of a ref field.					*/
/*									*/
/************************************************************************/

int docCalculateRefFieldString(		int *			pCalculated,
					int *			pNewSize,
					unsigned char *		target,
					int			targetSize,
					BufferDocument *	bd,
					const BufferItem *	paraBi,
					const DocumentField *	dfRef )
    {
    const char *		markName;
    int				markSize;

    SelectionScope		ssNew;
    BufferSelection		bsNew;

    int				len;

    if  ( docFieldGetRef( dfRef, &markName, &markSize ) )
	{ LDEB(1); *pCalculated= 0; return 0;	}

    docInitSelection( &bsNew );
    docInitSelectionScope( &ssNew );

    if  ( docFindBookmarkInDocument( &ssNew, &bsNew, bd, markName, markSize ) )
	{
	SLDEB(markName,markSize);

	strcpy( (char *)target, "<<??>>" );
	len= strlen( (char *)target );
	}
    else{
	int			beginMoved= 0;
	int			endMoved= 0;
	const unsigned char *	string;

	docConstrainSelectionToOneParagraph( &beginMoved, &endMoved, &bsNew );

	if  ( bsNew.bsEnd.bpStroff == bsNew.bsBegin.bpStroff )
	    { LLDEB(bsNew.bsEnd.bpStroff,bsNew.bsBegin.bpStroff);	}

	string= bsNew.bsBegin.bpBi->biParaString;
	len= bsNew.bsEnd.bpStroff- bsNew.bsBegin.bpStroff;

	if  ( len > targetSize )
	    { len=  targetSize;	}
	memcpy( target, string+ bsNew.bsBegin.bpStroff, len );
	target[len]= '\0';
	}

    *pNewSize= len;
    *pCalculated= 1;

    return 0;
    }

