/************************************************************************/
/*									*/
/*  Find utility routines.						*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>
#   include	<ctype.h>

#   include	<appDebugon.h>

#   include	"docBuf.h"
#   include	"docFind.h"

#   include	<reg.h>
#   include	<charnames.h>

/************************************************************************/
/*									*/
/*  Find the first occurrence of a regular expression in a paragraph.	*/
/*									*/
/************************************************************************/

int docFindParaFindNext(	const BufferItem *	bi,
				int			stroff,
				int *			pStart,
				int *			pLength,
				void *			through )
    {
    regProg *		prog= (regProg *)through;
    int			res;

    if  (  bi->biParaStrlen == 0 )
	{ return 1;	}

    res= regFindLeftToRight( prog, bi->biParaString+ stroff );

    if  ( ! res )
	{ return 1;	}

    *pStart= prog->rpStartp[0]- bi->biParaString;
    *pLength= prog->rpEndp[0]- prog->rpStartp[0];

    return 0;
    }

int docFindParaFindPrev(	const BufferItem *	bi,
				int			stroff,
				int *			pStart,
				int *			pLength,
				void *			through )
    {
    regProg *		prog= (regProg *)through;
    int			res;

    if  (  bi->biParaStrlen == 0 )
	{ return 1;	}

    res= regFindRightToLeft( prog, bi->biParaString, stroff );

    if  ( ! res )
	{ return 1;	}

    *pStart= prog->rpStartp[0]- bi->biParaString;
    *pLength= prog->rpEndp[0]- prog->rpStartp[0];

    return 0;
    }

static int docFindFindNext(	BufferSelection *	bs,
				const BufferPosition *	bpFrom,
				PARA_FIND_STRING	findNext,
				void *			through )
    {
    BufferItem *		bi= bpFrom->bpBi;
    int				stroff= bpFrom->bpStroff;

    int				ret;
    int				start;
    int				length;

    if  ( bi->biLevel != DOClevPARA )
	{ LLDEB(bi->biLevel,DOClevPARA); return -1;	}

    for (;;)
	{
	ret= (*findNext)( bi, stroff, &start, &length, through );

	if  ( ret == 0 )
	    {
	    docSetParaSelection( bs, bi, 1, start, length );

	    return ret;
	    }

	if  ( ret < 0 )
	    { LDEB(ret); return ret;	}

	bi= docNextParagraph( bi );
	if  ( ! bi )
	    { return 1;	}

	stroff= 0;
	}
    }

static int docFindFindPrev(	BufferSelection *	bs,
				const BufferPosition *	bpFrom,
				PARA_FIND_STRING	findPrev,
				void *			through )
    {
    BufferItem *		bi= bpFrom->bpBi;
    int				stroff= bpFrom->bpStroff;

    int				ret;
    int				start;
    int				length;

    if  ( bi->biLevel != DOClevPARA )
	{ LLDEB(bi->biLevel,DOClevPARA); return -1;	}

    for (;;)
	{
	if  ( stroff > 0 )
	    {
	    ret= (*findPrev)( bi, stroff, &start, &length, through );

	    if  ( ret == 0 )
		{
		docSetParaSelection( bs, bi, -1, start, length );

		return ret;
		}

	    if  ( ret < 0 )
		{ LDEB(ret); return ret;	}
	    }

	bi= docPrevParagraph( bi );
	if  ( ! bi )
	    { return 1;	}

	stroff= bi->biParaStrlen- 1;
	}
    }

int docFindFindNextInTree(	BufferSelection *	bs,
				const BufferPosition *	bpFrom,
				BufferItem *		biRoot,
				PARA_FIND_STRING	findNext,
				void *			through )
    {
    int			ret;

    BufferSelection	bsNew;
    BufferPosition	bpStart;

    int			fromBeginning= 0;

    if  ( ! bpFrom->bpBi )
	{ fromBeginning= 1;	}

    bpStart= *bpFrom;

    if  ( fromBeginning )
	{
	if  ( docFirstPosition( biRoot, &bpStart ) )
	    { LDEB(1); return -1;	}
	}

    docInitSelection( &bsNew );

    ret= docFindFindNext( &bsNew, &bpStart, findNext, through );

    if  ( ret < 0 )
	{ LDEB(ret); return ret;	}

    if  ( ! fromBeginning && ret )
	{
	if  ( docFirstPosition( biRoot, &bpStart ) )
	    { LDEB(1); return -1;	}

	docInitSelection( &bsNew );
	ret= docFindFindNext( &bsNew, &bpStart, findNext, through );

	if  ( ret < 0 )
	    { LDEB(ret); return ret;	}
	}

    if  ( ret == 0 )
	{
	bsNew.bsDirection= 1;
	bsNew.bsAnchor= bsNew.bsBegin;

	*bs= bsNew;
	}

    return ret;
    }

int docFindFindPrevInTree(	BufferSelection *	bs,
				const BufferPosition *	bpFrom,
				BufferItem *		biRoot,
				PARA_FIND_STRING	findPrev,
				void *			through )
    {
    int			ret;

    BufferSelection	bsNew;
    BufferPosition	bpStart;

    int			fromEnd= 0;

    if  ( ! bpFrom->bpBi )
	{ fromEnd= 1;	}

    bpStart= *bpFrom;

    if  ( fromEnd )
	{
	if  ( docLastPosition( biRoot, &bpStart ) )
	    { LDEB(1); return -1;	}
	}

    docInitSelection( &bsNew );

    ret= docFindFindPrev( &bsNew, &bpStart, findPrev, through );

    if  ( ret < 0 )
	{ LDEB(ret); return ret;	}

    if  ( ! fromEnd && ret )
	{
	if  ( docLastPosition( biRoot, &bpStart ) )
	    { LDEB(1); return -1;	}

	docInitSelection( &bsNew );
	ret= docFindFindPrev( &bsNew, &bpStart, findPrev, through );

	if  ( ret < 0 )
	    { LDEB(ret); return ret;	}
	}

    if  ( ! ret )
	{
	bsNew.bsDirection= -1;
	bsNew.bsAnchor= bsNew.bsEnd;

	*bs= bsNew;
	}

    return ret;
    }

/************************************************************************/
/*									*/
/*  Look for the next occurrence of something in a whole document	*/
/*  including the section headers and footers.				*/
/*									*/
/************************************************************************/

static int DOC_FindHeaderFooters[]=
    {
    DOCinFIRST_HEADER,		DOCinFIRST_FOOTER,
    DOCinSECT_HEADER,		DOCinSECT_FOOTER,
    DOCinLEFT_HEADER,		DOCinLEFT_FOOTER,
    DOCinRIGHT_HEADER,		DOCinRIGHT_FOOTER,
    };

static int DOC_FindHeaderFooterCount= 
			sizeof(DOC_FindHeaderFooters)/sizeof(int);

static HeaderFooter * docFindGetHeaderFooter(
				BufferItem *			sectBi,
				const DocumentProperties *	dp,
				int				hfHere )
    {
    const SectionProperties *	sp= &(sectBi->biSectProperties);

    switch( DOC_FindHeaderFooters[hfHere] )
	{
	case DOCinFIRST_HEADER:
	    if  ( ! sp->spHasTitlePage )
		{ return (HeaderFooter *)0;	}
	    return &(sectBi->biSectFirstPageHeader);

	case DOCinFIRST_FOOTER:
	    if  ( ! sp->spHasTitlePage )
		{ return (HeaderFooter *)0;	}
	    return &(sectBi->biSectFirstPageFooter);

	case DOCinSECT_HEADER:
	    if  ( dp->dpHasFacingPages )
		{ return (HeaderFooter *)0;	}
	    return &(sectBi->biSectHeader);

	case DOCinSECT_FOOTER:
	    if  ( dp->dpHasFacingPages )
		{ return (HeaderFooter *)0;	}
	    return &(sectBi->biSectFooter);

	case DOCinLEFT_HEADER:
	    if  ( ! dp->dpHasFacingPages )
		{ return (HeaderFooter *)0;	}
	    return &(sectBi->biSectLeftPageHeader);

	case DOCinLEFT_FOOTER:
	    if  ( ! dp->dpHasFacingPages )
		{ return (HeaderFooter *)0;	}
	    return &(sectBi->biSectLeftPageFooter);

	case DOCinRIGHT_HEADER:
	    if  ( ! dp->dpHasFacingPages )
		{ return (HeaderFooter *)0;	}
	    return &(sectBi->biSectRightPageHeader);

	case DOCinRIGHT_FOOTER:
	    if  ( ! dp->dpHasFacingPages )
		{ return (HeaderFooter *)0;	}
	    return &(sectBi->biSectRightPageFooter);

	default:
	    LDEB(DOC_FindHeaderFooters[hfHere]);
	    return (HeaderFooter *)0;
	}

    }

int docFindFindNextInDocument(	BufferSelection *	bs,
				SelectionScope *	ss,
				const BufferPosition *	bpFrom,
				BufferDocument *	bd,
				PARA_FIND_STRING	findNext,
				void *			through )
    {
    const DocumentProperties *	dp= &(bd->bdProperties);
    int				ret= -1;

    int				sectStep;
    int				sectFrom;

    int				hfFrom;

    BufferSelection		bsNew;

    BufferItem *		docBi= &(bd->bdItem);

    int				fromBeginning= 0;

    BufferPosition		bpStart;

    if  ( ! bpFrom->bpBi )
	{ fromBeginning= 1;	}

    bpStart= *bpFrom;

    docInitSelection( &bsNew );

    if  ( ss->ssInHeaderFooter == DOCinBODY )
	{
	sectFrom= -1;
	hfFrom= 0;
	}
    else{
	sectFrom= ss->ssHeaderFooterSection;

	for ( hfFrom= 0; hfFrom < DOC_FindHeaderFooterCount; hfFrom++ )
	    {
	    if  ( DOC_FindHeaderFooters[hfFrom] == ss->ssInHeaderFooter )
		{ break;	}
	    }

	if  ( hfFrom >= DOC_FindHeaderFooterCount )
	    { LLDEB(ss->ssInHeaderFooter,hfFrom); hfFrom= 0; }
	}

    for ( sectStep= 0; sectStep < docBi->biChildCount+ 2; sectStep++ )
	{
	int		sectHere;

	sectHere= ( sectFrom+ sectStep+ docBi->biChildCount+ 2 );
	sectHere= sectHere % ( docBi->biChildCount+ 1 )- 1;

	if  ( sectHere < 0 )
	    {
	    if  ( fromBeginning )
		{
		if  ( docFirstPosition( docBi, &bpStart ) )
		    { LDEB(1); return -1;	}
		}

	    ret= docFindFindNext( &bsNew, &bpStart, findNext, through );

	    if  ( ret < 0 )
		{ LDEB(ret); return ret;	}

	    if  ( ret == 0 )
		{
		bsNew.bsDirection= 1;
		bsNew.bsAnchor= bsNew.bsBegin;

		*bs= bsNew;
		ss->ssInHeaderFooter= DOCinBODY;
		ss->ssHeaderFooterSection= -1;
		ss->ssHeaderFooterPage= -1;

		return 0;
		}

	    fromBeginning= 1;
	    }
	else{
	    int			hfHere;

	    for ( hfHere= hfFrom; hfHere < DOC_FindHeaderFooterCount; hfHere++ )
		{
		BufferItem *		sectBi= docBi->biChildren[sectHere];
		HeaderFooter *		hf;

		int			page;
		int			lastPage;

		hf= docFindGetHeaderFooter( sectBi, dp, hfHere );
		if  ( ! hf || ! hf->hfItem )
		    { continue;	}

		lastPage= sectBi->biBelowPosition.lpPage;
		if  ( lastPage > sectBi->biTopPosition.lpPage+ 2 )
		    { lastPage=  sectBi->biTopPosition.lpPage+ 2;	}
		for ( page= sectBi->biTopPosition.lpPage;
		      page <= lastPage;
		      page++ )
		    {
		    HeaderFooter *	hfTest;
		    int			inHdFt;

		    inHdFt= docWhatPageHeader( &hfTest, sectBi, page, dp );
		    if  ( inHdFt == DOC_FindHeaderFooters[hfHere]	&&
			  hfTest					&&
			  hfTest->hfItem				)
			{ break;	}

		    inHdFt= docWhatPageFooter( &hfTest, sectBi, page, dp );
		    if  ( inHdFt == DOC_FindHeaderFooters[hfHere]	&&
			  hfTest					&&
			  hfTest->hfItem				)
			{ break;	}
		    }

		if  ( page > lastPage )
		    { continue;	}

		if  ( fromBeginning )
		    {
		    if  ( docFirstPosition( hf->hfItem, &bpStart ) )
			{ LDEB(1); return -1;	}
		    }

		ret= docFindFindNext( &bsNew, &bpStart, findNext, through );

		if  ( ret < 0 )
		    { LDEB(ret); return ret;	}

		if  ( ret == 0 )
		    {
		    bsNew.bsDirection= 1;
		    bsNew.bsAnchor= bsNew.bsBegin;

		    *bs= bsNew;
		    ss->ssInHeaderFooter= DOC_FindHeaderFooters[hfHere];
		    ss->ssHeaderFooterSection= sectHere;
		    ss->ssHeaderFooterPage= page;

		    return 0;
		    }

		fromBeginning= 1;
		}
	    }

	hfFrom= 0;
	}

    return 1;
    }

int docFindFindPrevInDocument(	BufferSelection *	bs,
				SelectionScope *	ss,
				const BufferPosition *	bpFrom,
				BufferDocument *	bd,
				PARA_FIND_STRING	findPrev,
				void *			through )
    {
    const DocumentProperties *	dp= &(bd->bdProperties);
    int				ret= -1;

    int				sectStep;
    int				sectFrom;

    int				hfFrom;

    BufferSelection		bsNew;

    BufferItem *		docBi= &(bd->bdItem);

    int				fromEnd= 0;

    BufferPosition		bpStart;

    if  ( ! bpFrom->bpBi )
	{ fromEnd= 1;	}

    bpStart= *bpFrom;

    docInitSelection( &bsNew );

    if  ( ss->ssInHeaderFooter == DOCinBODY )
	{
	sectFrom= -1;
	hfFrom= DOC_FindHeaderFooterCount- 1;
	}
    else{
	sectFrom= ss->ssHeaderFooterSection;

	for ( hfFrom= 0; hfFrom < DOC_FindHeaderFooterCount; hfFrom++ )
	    {
	    if  ( DOC_FindHeaderFooters[hfFrom] == ss->ssInHeaderFooter )
		{ break;	}
	    }

	if  ( hfFrom >= DOC_FindHeaderFooterCount )
	    {
	    LLDEB(ss->ssInHeaderFooter,hfFrom);
	    hfFrom= DOC_FindHeaderFooterCount- 1;
	    }
	}

    for ( sectStep= 0; sectStep < docBi->biChildCount+ 2; sectStep++ )
	{
	int		sectHere;

	sectHere= ( sectFrom- sectStep+ 2* docBi->biChildCount+ 3 );
	sectHere= sectHere % ( docBi->biChildCount+ 1 )- 1;

	if  ( sectHere < 0 )
	    {
	    if  ( fromEnd )
		{
		if  ( docLastPosition( docBi, &bpStart ) )
		    { LDEB(1); return -1;	}
		}

	    ret= docFindFindPrev( &bsNew, &bpStart, findPrev, through );

	    if  ( ret < 0 )
		{ LDEB(ret); return ret;	}

	    if  ( ret == 0 )
		{
		bsNew.bsDirection= -1;
		bsNew.bsAnchor= bsNew.bsEnd;

		*bs= bsNew;
		ss->ssInHeaderFooter= DOCinBODY;
		ss->ssHeaderFooterSection= -1;
		ss->ssHeaderFooterPage= -1;

		return 0;
		}

	    fromEnd= 1;
	    }
	else{
	    int			hfHere;

	    for ( hfHere= hfFrom; hfHere >= 0; hfHere-- )
		{
		BufferItem *		sectBi= docBi->biChildren[sectHere];
		HeaderFooter *		hf;

		int			page;
		int			lastPage;

		hf= docFindGetHeaderFooter( sectBi, dp, hfHere );
		if  ( ! hf || ! hf->hfItem )
		    { continue;	}

		lastPage= sectBi->biBelowPosition.lpPage;
		if  ( lastPage > sectBi->biTopPosition.lpPage+ 2 )
		    { lastPage=  sectBi->biTopPosition.lpPage+ 2;	}
		for ( page= lastPage;
		      page >= sectBi->biTopPosition.lpPage;
		      page-- )
		    {
		    HeaderFooter *	hfTest;
		    int			inHdFt;

		    inHdFt= docWhatPageHeader( &hfTest, sectBi, page, dp );
		    if  ( inHdFt == DOC_FindHeaderFooters[hfHere]	&&
			  hfTest					&&
			  hfTest->hfItem				)
			{ break;	}

		    inHdFt= docWhatPageFooter( &hfTest, sectBi, page, dp );
		    if  ( inHdFt == DOC_FindHeaderFooters[hfHere]	&&
			  hfTest					&&
			  hfTest->hfItem				)
			{ break;	}
		    }

		if  ( page < sectBi->biTopPosition.lpPage )
		    { continue;	}

		if  ( fromEnd )
		    {
		    if  ( docLastPosition( hf->hfItem, &bpStart ) )
			{ LDEB(1); return -1;	}
		    }

		ret= docFindFindPrev( &bsNew, &bpStart, findPrev, through );

		if  ( ret < 0 )
		    { LDEB(ret); return ret;	}

		if  ( ret == 0 )
		    {
		    bsNew.bsDirection= -1;
		    bsNew.bsAnchor= bsNew.bsEnd;

		    *bs= bsNew;
		    ss->ssInHeaderFooter= DOC_FindHeaderFooters[hfHere];
		    ss->ssHeaderFooterSection= sectHere;
		    ss->ssHeaderFooterPage= page;

		    return 0;
		    }

		fromEnd= 1;
		}
	    }

	hfFrom= DOC_FindHeaderFooterCount- 1;
	}

    return 1;
    }

/************************************************************************/
/*									*/
/*  Find a particular bookmark in a document.				*/
/*									*/
/************************************************************************/

int docFindBookmarkInDocument(	SelectionScope *	ss,
				BufferSelection *	bs,
				BufferDocument *	bd,
				const char *		markName,
				int			markSize )
    {
    SelectionScope	ssNew;
    BufferSelection	bsNew;
    BufferPosition	bp;
    BufferItem *	bi;

    int			foundBegin= 0;
    int			foundEnd= 0;

    int			beginObjectNumber= -1;

    docInitSelectionScope( &ssNew );
    docInitSelection( &bsNew );

    if  ( docFirstPosition( &(bd->bdItem), &bp ) )
	{ return 1;	}

    bi= bp.bpBi;
    while( bi )
	{
	int		part;
	TextParticule *	tp;

	tp= bi->biParaParticules;
	for ( part= 0; part < bi->biParaParticuleCount; tp++, part++ )
	    {
	    DocumentField *	df;
	    const char *	foundName;
	    int			foundSize;


	    if  ( tp->tpKind == DOCkindFIELDSTART )
		{
		df= bd->bdFieldList.dflFields+ tp->tpObjectNumber;

		if  ( df->dfKind == DOCfkBOOKMARK			&&
		      ! docFieldGetBookmark( df,
					&foundName, &foundSize )	&&
		      foundSize == markSize				&&
		      ! memcmp( foundName, markName, markSize )		)
		    {
		    foundBegin= 1;
		    beginObjectNumber= tp->tpObjectNumber;
		    bsNew.bsBegin.bpBi= bi;
		    bsNew.bsBegin.bpStroff= tp->tpStroff;
		    }
		}

	    if  ( tp->tpKind == DOCkindFIELDEND				&&
		  tp->tpObjectNumber == beginObjectNumber		)
		{
		foundEnd= 1;
		bsNew.bsEnd.bpBi= bi;
		bsNew.bsEnd.bpStroff= tp->tpStroff;
		}
	    }

	bi= docNextParagraph( bi );
	}

    if  ( ! foundBegin || ! foundEnd )
	{ return 1;	}

    *ss= ssNew; *bs= bsNew; return 0;
    }
