/************************************************************************/
/*									*/
/*  Fields: parts of the document that are calculated in stead of typed	*/
/*  by the user.							*/
/*									*/
/************************************************************************/

#   ifndef DOC_FIELD_H
#   define DOC_FIELD_H

#   include	<utilMemoryBuffer.h>
#   include	"docObject.h"

struct BufferItem;
struct BufferDocument;
struct DocumentField;

/************************************************************************/
/*									*/
/*  Kind of field. Is an index in a descriptive array of field kinds.	*/
/*									*/
/*  Fields in the 'Ted' sense are not necessarily fileds in the 'Word'	*/
/*  sense. Everything inside the text, that can possibly result in	*/
/*  a piece of document, but is possibly under the control of the	*/
/*  application is a field in the sense of 'Ted'.			*/
/*									*/
/*  FieldKindInformation:						*/
/*  a)  The (case insensitive) string that identifies the field in the	*/
/*	field instructions. NOTE that the notion of a field is abused	*/
/*	by 'Ted' for a few things that are not fields in MS-Word.	*/
/*  b)  Some things that are a destination in RTF are stored as a field	*/
/*	in Ted. This is the control word of the destination.		*/
/*  c)  The level at which this kind of field occurs.			*/
/*  d)  Tells whether this kind of field is a field in the RTF file.	*/
/*  e)  Tells whether this kind of field is a destination in the RTF	*/
/*	file.								*/
/*  f1) Recalculate a TEXT level field.					*/
/*  f2) Recalculate the string for a TEXT level field.			*/
/*  g)  When to recalculate fields in the text.				*/
/*  h)  Is the field result editable such as with a HYPERLINK or	*/
/*	readonly such as with a PAGEREF?				*/
/*									*/
/************************************************************************/

/*  f1  */
typedef int (*CALCULATE_TEXT_PARTICULES)(
				int *				pCalculated,
				struct BufferDocument *		bd,
				int *				pPartShift,
				int *				pStroffShift,
				struct BufferItem *		bi,
				int				part,
				int				partCount,
				struct DocumentField *		df,
				void *				voidadd,
				DOC_CLOSE_OBJECT		closeObject );

/*  f2  */
typedef int (*CALCULATE_TEXT_STRING)(
				int *				pCalculated,
				int *				pNewSize,
				unsigned char *			target,
				int				targetSize,
				struct BufferDocument *		bd,
				const struct BufferItem *	paraBi,
				const struct DocumentField *	df );

/*  g  */
#   define	FIELDdoNOTHING		0
#   define	FIELDdoNEVER		0
#   define	FIELDdoDOC_FORMATTED	(1<<0)
#   define	FIELDdoPAGE_NUMBER	(1<<1)
#   define	FIELDdoDOC_INFO		(1<<2)
#   define	FIELDdoDOC_COMPLETE	(1<<3)

typedef struct FieldKindInformation
    {
    const char *		fkiLabel;			/*  a	*/
    const char *		fkiDestinationLabel;		/*  b	*/
    int				fkiLevel;			/*  c	*/
    int				fkiIsFieldInRtf;		/*  d	*/
    int				fkiIsDestinationInRtf;		/*  e	*/
    CALCULATE_TEXT_PARTICULES	fkiCalculateTextParticules;	/*  f1	*/
    CALCULATE_TEXT_STRING	fkiCalculateTextString;		/*  f2	*/
    unsigned int		fkiCalculateWhen;		/*  g	*/
    unsigned int		fkiResultEditable;		/*  h	*/
    } FieldKindInformation;

typedef enum FieldKind
    {
    DOCfkFREE= -1,
    DOCfkUNKNOWN= 0,
    DOCfkHYPERLINK,
    DOCfkXE,
    DOCfkTC,
    DOCfkTCN,
    DOCfkBOOKMARK,
    DOCfkPAGE,
    DOCfkPAGEREF,
    DOCfkNUMPAGES,
    DOCfkREF,

    DOCfkCREATEDATE,
    DOCfkSAVEDATE,
    DOCfkPRINTDATE,

    DOCfkAUTHOR,
    DOCfkCOMMENTS,
    DOCfkKEYWORDS,
    DOCfkSUBJECT,
    DOCfkTITLE,
    DOCfkFILENAME,

    DOCfkFOOTNOTE,
    DOCfkCHFTN,

    DOCfkINCLUDEPICTURE,

    DOCfk_COUNT
    } FieldKind;

typedef struct DocumentField
    {
    int			dfPage;
    FieldKind		dfKind;
    MemoryBuffer	dfData;
    MemoryBuffer	dfInstructions;
    struct BufferItem *	dfReferencedItem;
    } DocumentField;

typedef struct FieldInstructionsComponent
    {
    int		ficOffset;
    int		ficSize;
    } FieldInstructionsComponent;

#   define	DOCmaxBOOKMARK	39

typedef struct DocumentFieldList
    {
    DocumentField *	dflFields;
    int			dflFieldCount;
    } DocumentFieldList;

/************************************************************************/
/*									*/
/*  Field Kind Information.						*/
/*									*/
/************************************************************************/

extern const FieldKindInformation	DOC_FieldKinds[];
extern const int			DOC_FieldKindCount;

#   endif /*  DOC_FIELD_H  */
