/************************************************************************/
/*									*/
/*  Evaluate fields+ the list of kinds of fields.			*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<appDebugon.h>

#   include	<appUnit.h>
#   include	"docBuf.h"

/************************************************************************/
/*									*/
/*  Count the number of particules inside a text level field. The	*/
/*  begin and end particules are not counted.				*/
/*									*/
/*  1)  Do some sanity checks on the proper nesting of fields.. Just	*/
/*	to have a safe feeling.						*/
/*									*/
/************************************************************************/

static int docCountParticulesInField(	BufferItem *		bi,
					int			part,
					int			partUpto )
    {
    int				fieldLevel= 0;
    int				partCount= 0;
    int				fieldNumber;

    const TextParticule *	tp;

    tp= bi->biParaParticules+ part;
    if  ( tp->tpKind != DOCkindFIELDSTART )
	{ LDEB(tp->tpKind); return -1;	}
    fieldNumber= tp->tpObjectNumber;

    tp++; part++;
    while( part < partUpto )
	{
	if  ( tp->tpKind == DOCkindFIELDSTART )
	    {
	    /*  1  */
	    if  ( tp->tpObjectNumber == fieldNumber )
		{ LLDEB(tp->tpObjectNumber,fieldNumber);	}

	    fieldLevel++;
	    }

	if  ( tp->tpKind == DOCkindFIELDEND )
	    {
	    if  ( tp->tpObjectNumber == fieldNumber )
		{
		/*  1 
		if  ( fieldLevel != 0 )
		    { LDEB(fieldLevel);	}
		*/

		return partCount;
		}

	    fieldLevel--;
	    }

	partCount++, part++; tp++;
	}

    /*  1  */
    LLDEB(fieldLevel,fieldNumber); return -1;
    }

/************************************************************************/
/*									*/
/*  Substitute an individual text field in a paragraph.			*/
/*									*/
/*  NOTE: This routine is not recursive. Nested fields are handeled	*/
/*	by the caller.							*/
/*									*/
/************************************************************************/

static int docRecalculateParaStringTextParticules(
				int *				pCalculated,
				BufferDocument *		bd,
				int *				pPartShift,
				int *				pStroffShift,
				BufferItem *			bi,
				int				part,
				int				partCount,
				DocumentField *			df,
				void *				voidadd,
				DOC_CLOSE_OBJECT		closeObject )
    {
    unsigned char			scratch[500+ 1];

    int					calculated= 0;

    int					newSize;
    int					d;

    TextParticule *			tp= bi->biParaParticules+ part;

    TextAttribute			ta;

    int					past;
    int					stroff;
    int					partsMade;

    int					i;

    const FieldKindInformation *	fki= DOC_FieldKinds+ df->dfKind;

    if  ( (*fki->fkiCalculateTextString)( &calculated, &newSize, scratch,
					    sizeof(scratch)- 1, bd, bi, df ) )
	{ SDEB(fki->fkiLabel); return -1;	}

    if  ( ! calculated )
	{
	*pCalculated= 0;
	*pPartShift= 0;
	*pStroffShift= 0;
	return 0;
	}

    if  ( tp->tpStrlen == newSize					&&
	  ! memcmp( bi->biParaString+ tp->tpStroff+ *pStroffShift,
						    scratch, newSize )	)
	{
	*pCalculated= 0;
	*pPartShift= 0;
	*pStroffShift= 0;
	return 0;
	}

    ta= tp[1].tpTextAttribute;
    past= tp[1+partCount].tpStroff+ *pStroffShift;
    stroff= tp[1].tpStroff+ *pStroffShift;

    if  ( docParaStringReplace( &d, bi, stroff, past, scratch, newSize ) )
	{ LDEB(newSize); return -1;	}

    tp= bi->biParaParticules+ part+ 1;
    for ( i= 0; i < partCount; tp++, i++ )
	{
	(*closeObject)( bd, bi, tp, voidadd );
	docCleanParticuleObject( bi, tp );
	}

    partsMade= docRedivideStringInParticules( bi, stroff, newSize,
						part+ 1, partCount, ta );
    if  ( partsMade < partCount )
	{
	docDeleteParticules( bi, part+ 1+ partsMade, partCount- partsMade );
	}

    *pCalculated= 1;
    *pPartShift= partsMade- partCount;
    *pStroffShift += d;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Substitute the text fields in a paragraph.				*/
/*									*/
/*  1)  For all fields in range...					*/
/*	NOTE that the end of the range may have been shifted by the	*/
/*	calculation of field results.					*/
/*  2)  Shift the particule by what previous calculations have changed	*/
/*	in size.							*/
/*  3)  Not the beginning of a field.. Irrelevant (+sanity chaeck)	*/
/*  4)  Retrieve the field. Do some sanity checks: Only text level	*/
/*	fields are really supported.					*/
/*  5)  Count the number of paricules in the field.			*/
/*  6)  When the field is to be recalculated.. do so.			*/
/*	NOTE that this may shift both the array of particules and the	*/
/*	paragraph text.							*/
/*	Otherwise just shift the offsets of the particules inside the	*/
/*	field.								*/
/*  7)  When there is sufficient space inside the field to contain	*/
/*	yet another one.. go into recursion.				*/
/*	NOTE that this may shift both the array of particules and the	*/
/*	paragraph text.							*/
/*  8)  Shift the end particule of the field.				*/
/*  9)  Set the current position in the loop to the end particule. The	*/
/*	loop increment will move to the particule after the field.	*/
/*									*/
/************************************************************************/

static int docRecalculateParaTextFields(
				int *			pChanged,
				BufferDocument *	bd,
				int *			pPartShift,
				int *			pStroffShift,
				BufferItem *		bi,
				int			part,
				int			partUpto,
				unsigned int		whenMask,
				void *			voidadd,
				DOC_CLOSE_OBJECT	closeObject )
    {
    /*  1  */
    for ( part= part; part < partUpto+ *pPartShift; part++ )
	{
	TextParticule *			tp= bi->biParaParticules+ part;

	DocumentField *			df;
	const FieldKindInformation *	fki;

	int				endPart;
	int				partCount;

	/*  2  */
	tp->tpStroff += *pStroffShift;

	/*  3  */
	if  ( tp->tpKind != DOCkindFIELDSTART )
	    {
	    /*
	    if  ( tp->tpKind == DOCkindFIELDEND )
		{ LDEB(tp->tpKind);	}
	    */
	    continue;
	    }

	/*  4  */
	df= bd->bdFieldList.dflFields+ tp->tpObjectNumber;
	if  ( df->dfKind < 0 || df->dfKind >= DOC_FieldKindCount )
	    { LLDEB(df->dfKind,DOC_FieldKindCount); continue;	}

	fki= DOC_FieldKinds+ df->dfKind;
	if  ( fki->fkiLevel != DOClevTEXT )
	    {
	    /*
	    SLDEB(fki->fkiLabel,fki->fkiLevel);
	    SDEB(df->dfInstructions.odBytes);
	    */
	    continue;
	    }

	/*  5  */
	partCount= docCountParticulesInField( bi, part, partUpto+ *pPartShift );
	if  ( partCount < 0 )
	    { LDEB(partCount); continue;	}
	endPart= part+ 1+ partCount;

	/*  6  */
	if  ( ( fki->fkiCalculateWhen & whenMask )		&&
	      fki->fkiCalculateTextParticules			)
	    {
	    int			partShift= 0;
	    int			calculated= 0;

	    if  ( (*fki->fkiCalculateTextParticules)( &calculated, bd,
			&partShift, pStroffShift, bi, part, partCount, df,
			voidadd, closeObject ) )
		{ LDEB(1); return -1;	}

	    if  ( calculated )
		{ *pChanged= 1; }

	    endPart += partShift;
	    *pPartShift += partShift;
	    }
	else{
	    int		p;

	    tp= bi->biParaParticules+ part+ 1;
	    for ( p= part+ 1; p < endPart; tp++, p++ )
		{ tp->tpStroff += *pStroffShift; }
	    }

	/*  7  */
	if  ( endPart- part >= 2 )
	    {
	    int			partShift= 0;
	    int			stroffShift= 0;

	    if  ( docRecalculateParaTextFields( pChanged, bd,
					&partShift, &stroffShift,
					bi, part+ 1, endPart, whenMask,
					voidadd, closeObject ) )
		{ LDEB(1); return -1;	}

	    endPart += partShift;
	    *pPartShift += partShift;
	    *pStroffShift += stroffShift;
	    }

	/*  8  */
	tp= bi->biParaParticules+ endPart;
	if  ( tp->tpKind != DOCkindFIELDEND )
	    { LDEB(tp->tpKind);	}

	tp->tpStroff += *pStroffShift;

	/*  9  */
	part= endPart;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  Substitute the text fields in a buffer item.			*/
/*									*/
/************************************************************************/

int docRecalculateTextLevelFields(	int *			pChanged,
					BufferDocument *	bd,
					BufferItem *		bi,
					unsigned int		whenMask,
					void *			voidadd,
					DOC_CLOSE_OBJECT	closeObject )
    {
    int			i;

    int			partShift;
    int			stroffShift;

    switch( bi->biLevel )
	{
	case DOClevDOC:
	case DOClevSECT:
	case DOClevROW:
	case DOClevCELL:
	    for ( i= 0; i < bi->biChildCount; i++ )
		{
		if  ( docRecalculateTextLevelFields( pChanged, bd,
					    bi->biChildren[i], whenMask,
					    voidadd, closeObject ) )
		    { LDEB(i); return -1;	}
		}
	    return 0;

	case DOClevPARA:

	    partShift= 0;
	    stroffShift= 0;

	    if  ( docRecalculateParaTextFields( pChanged, bd,
				&partShift, &stroffShift,
				bi, 0, bi->biParaParticuleCount, whenMask,
				voidadd, closeObject ) )
		{ LDEB(1); return -1;	}
	    return 0;

	default:
	    LDEB(bi->biLevel); return -1;
	}

    return 0;
    }

/************************************************************************/
/*									*/
/*  The Kinds of Fields actively supported.				*/
/*									*/
/************************************************************************/

#   define	NOT_IN_RTF	0
#   define	FIELD_IN_RTF	1

#   define	NO_DEST		0
#   define	DEST_IN_RTF	1

#   define	RESULT_READONLY	0
#   define	RESULT_EDITABLE	1

const FieldKindInformation DOC_FieldKinds[]=
{
    {
	"-UNKNOWN", (char *)0,
		DOClevANY,
		NOT_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_READONLY,
    },
    {
	"HYPERLINK", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_EDITABLE,
    },
    {
	"-XE", "xe",
		DOClevTEXT,
		NOT_IN_RTF,
		DEST_IN_RTF,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_READONLY,
    },
    {
	"-TC", "tc",
		DOClevTEXT,
		NOT_IN_RTF,
		DEST_IN_RTF,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_READONLY,
    },
    {
	"-TCN", "tcn",
		DOClevTEXT,
		NOT_IN_RTF,
		DEST_IN_RTF,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_READONLY,
    },
    {
	"-BOOKMARK", (char *)0,
		DOClevTEXT,
		NOT_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_EDITABLE,
    },
    {
	"PAGE", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculatePageFieldString,
		FIELDdoPAGE_NUMBER,
		RESULT_READONLY,
    },
    {
	"PAGEREF", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculatePagerefFieldString,
		FIELDdoDOC_FORMATTED,
		RESULT_READONLY,
    },
    {
	"NUMPAGES", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateNumpagesFieldString,
		FIELDdoDOC_FORMATTED,
		RESULT_READONLY,
    },
    {
	"REF", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateRefFieldString,
		FIELDdoDOC_COMPLETE,
		RESULT_READONLY,
    },
    {
	"CREATEDATE", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocDateFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"SAVEDATE", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocDateFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"PRINTDATE", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocDateFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"AUTHOR", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocStringFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"COMMENTS", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocStringFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"KEYWORDS", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocStringFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"SUBJECT", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocStringFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"TITLE", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateDocStringFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"FILENAME", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateParaStringTextParticules,
		docCalculateFilenameFieldString,
		FIELDdoDOC_INFO,
		RESULT_READONLY,
    },
    {
	"-FOOTNOTE", (char *)0,
		DOClevTEXT,
		NOT_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_READONLY,
    },
    {
	"-CHFTN", (char *)0,
		DOClevTEXT,
		NOT_IN_RTF,
		NO_DEST,
		(CALCULATE_TEXT_PARTICULES)0,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoNEVER,
		RESULT_READONLY,
    },
    {
	"INCLUDEPICTURE", (char *)0,
		DOClevTEXT,
		FIELD_IN_RTF,
		NO_DEST,
		docRecalculateIncludePictureField,
		(CALCULATE_TEXT_STRING)0,
		FIELDdoDOC_COMPLETE,
		RESULT_READONLY,
    },
};

const int DOC_FieldKindCount=
			sizeof(DOC_FieldKinds)/sizeof(FieldKindInformation);

