/************************************************************************/
/*									*/
/*  Document Properties.						*/
/*									*/
/************************************************************************/

#   ifndef	DOC_DOCUMENT_PROPERTIES_H
#   define	DOC_DOCUMENT_PROPERTIES_H

#   include	<time.h>

#   include	<appGeo.h>
#   include	<appUnit.h>
#   include	<docFont.h>
#   include	<bmcolor.h>

#   define	DPfetFOOT_ONLY		0
#   define	DPfetEND_ONLY		1
#   define	DPfetFOOT_END_BOTH	2

typedef enum NotesPosition
    {
    DPftnPOS_SECT_END= 0,
    DPftnPOS_DOC_END,
    DPftnPOS_BELOW_TEXT,
    DPftnPOS_PAGE_BOTTOM,

    DPftnPOS__COUNT
    } NotesPosition;

typedef enum NotesRestart
    {
    DPftnRST_CONTINUOUS= 0,
    DPftnRST_PER_SECTION,
    DPftnRST_PER_PAGE,

    DPftnRST__COUNT
    } NotesRestart;

typedef enum NoteNumberStyle
    {
    DPftnNAR= 0,
    DPftnNALC,
    DPftnNAUC,
    DPftnNRLC,
    DPftnNRUC,
    DPftnNCHI,

    DPftn_NCOUNT
    } NoteNumberStyle;

typedef enum DocumentProperty
    {
    DPpropNONE= -1,

    DPpropSTART_PAGE= DGprop_COUNT,
    DPpropFACING_PAGES,

    DPpropFOOTNOTE_POSITION,
    DPpropFOOTNOTE_RESTART,
    DPpropFOOTNOTE_STYLE,
    DPpropFOOTNOTE_STARTNR,

    DPpropENDNOTE_POSITION,
    DPpropENDNOTE_RESTART,
    DPpropENDNOTE_STYLE,
    DPpropENDNOTE_STARTNR,

    DPpropDEFTAB,
    DPpropANSICPG,

    DPprop_COUNT
    } DocumentProperty;

typedef struct DocumentProperties
    {
    int			dpContainsTables;
    int			dpTabIntervalTwips;
    int			dpDefaultColor;
    int			dpDefaultFont;
    int			dpAnsiCodePage;

    int			dpStartPageNumber;
    int			dpStartFootnoteNumber;
    int			dpStartEndnoteNumber;

    unsigned int	dpHasFacingPages:1;
    unsigned int	dpWidowControl:1;

    unsigned int	dpFootEndNoteType:2;
    unsigned int	dpFootnotePosition:2;
    unsigned int	dpFootnotesRestart:2;
    unsigned int	dpFootnoteNumberStyle:3;
    unsigned int	dpEndnotePosition:2;
    unsigned int	dpEndnotesRestart:2;
    unsigned int	dpEndnoteNumberStyle:3;

    DocumentGeometry	dpGeometry;
    DocumentFontList	dpFontList;

    RGB8Color *		dpColors;
    int			dpColorCount;

    unsigned char **	dpAuthors;
    int			dpAuthorCount;

    struct tm		dpCreatim;
    struct tm		dpRevtim;
    struct tm		dpPrintim;

    unsigned char *	dpTitle;
    unsigned char *	dpSubject;
    unsigned char *	dpKeywords;
    unsigned char *	dpComment;
    unsigned char *	dpAuthor;
    unsigned char *	dpHlinkbase;

    unsigned char *	dpFilename;
    } DocumentProperties;

#   define	docHasDocumentInfo( dp )		\
		( (dp)->dpTitle			||	\
		  (dp)->dpSubject		||	\
		  (dp)->dpKeywords		||	\
		  (dp)->dpComment		||	\
		  (dp)->dpHlinkbase		||	\
		  (dp)->dpAuthor		||	\
		  (dp)->dpCreatim.tm_mday != 0	||	\
		  (dp)->dpRevtim.tm_mday != 0	||	\
		  (dp)->dpPrintim.tm_mday != 0	)

/************************************************************************/
/*									*/
/*  Routine Declarations.						*/
/*									*/
/************************************************************************/

extern void docInitDocumentProperties(	DocumentProperties *		dp );

extern void docCleanDocumentProperties(	DocumentProperties *		dp );

extern int docCopyDocumentProperties(	DocumentProperties *		to,
					const DocumentProperties *	from );

extern int docUpdDocumentProperties(	unsigned int *		pChgPask,
				DocumentProperties *		dp,
				unsigned int			updMask,
				const DocumentProperties *	dpNew );

extern int docPropertiesSetFilename(	DocumentProperties *	dp,
					const char *		filename );

#   endif	/*  DOC_DOCUMENT_PROPERTIES_H  */
