/************************************************************************/
/*									*/
/*  Buffer administration routines.					*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	<stdlib.h>
#   include	<string.h>
#   include	<stdio.h>

#   include	<utilPropMask.h>
#   include	<appDebugon.h>

#   include	"docDocumentProperties.h"

/************************************************************************/
/*									*/
/*  Initialise Document Properties.					*/
/*									*/
/************************************************************************/

void docInitDocumentProperties(	DocumentProperties *	dp )
    {
    dp->dpContainsTables= 0;
    dp->dpTabIntervalTwips= 720;
    dp->dpDefaultColor= 0;
    dp->dpDefaultFont= -1;
    dp->dpAnsiCodePage= -1;

    dp->dpStartPageNumber= 1;
    dp->dpStartFootnoteNumber= 1;
    dp->dpStartEndnoteNumber= 1;

    dp->dpFootEndNoteType= DPfetFOOT_ONLY;
    dp->dpFootnotePosition= DPftnPOS_PAGE_BOTTOM;
    dp->dpEndnotePosition= DPftnPOS_DOC_END;
    dp->dpFootnotesRestart= DPftnRST_CONTINUOUS;
    dp->dpEndnotesRestart= DPftnRST_CONTINUOUS;
    dp->dpFootnoteNumberStyle= DPftnNAR;
    dp->dpEndnoteNumberStyle= DPftnNAR;

    dp->dpHasFacingPages= 0;
    dp->dpWidowControl= 0;

    appInitDocumentGeometry( &(dp->dpGeometry) );

    docInitFontList( &(dp->dpFontList) );

    dp->dpColors= (RGB8Color *)0;
    dp->dpColorCount= 0;

    dp->dpAuthors= (unsigned char **)0;
    dp->dpAuthorCount= 0;

    dp->dpTitle= (unsigned char *)0;
    dp->dpSubject= (unsigned char *)0;
    dp->dpKeywords= (unsigned char *)0;
    dp->dpComment= (unsigned char *)0;
    dp->dpAuthor= (unsigned char *)0;
    dp->dpHlinkbase= (unsigned char *)0;
    dp->dpFilename= (unsigned char *)0;

    appInvalidateTime( &(dp->dpCreatim) );
    appInvalidateTime( &(dp->dpRevtim) );
    appInvalidateTime( &(dp->dpPrintim) );
    }

void docCleanDocumentProperties(	DocumentProperties *	dp )
    {
    int		i;

    docCleanFontList( &(dp->dpFontList) );

    if  ( dp->dpColors )
	{ free( dp->dpColors );	}

    for ( i= 0; i < dp->dpAuthorCount; i++ )
	{ free( dp->dpAuthors[i] );	}
    if  ( dp->dpAuthors )
	{ free( dp->dpAuthors );	}

    appInvalidateTime( &(dp->dpCreatim) );
    appInvalidateTime( &(dp->dpRevtim) );
    appInvalidateTime( &(dp->dpPrintim) );

    if  ( dp->dpTitle )
	{ free( dp->dpTitle );	}
    if  ( dp->dpSubject )
	{ free( dp->dpSubject );	}
    if  ( dp->dpKeywords )
	{ free( dp->dpKeywords );	}
    if  ( dp->dpComment )
	{ free( dp->dpComment );	}
    if  ( dp->dpAuthor )
	{ free( dp->dpAuthor );	}
    if  ( dp->dpHlinkbase )
	{ free( dp->dpHlinkbase );	}
    if  ( dp->dpFilename )
	{ free( dp->dpFilename );	}

    return;
    }

int docCopyDocumentProperties(	DocumentProperties *		to,
				const DocumentProperties *	from )
    {
    int			i;
    DocumentProperties	copy;

    copy= *from;

    docInitFontList( &(copy.dpFontList) );
    copy.dpColorCount= 0;
    copy.dpColors= (RGB8Color *)0;
    copy.dpAuthorCount= 0;
    copy.dpAuthors= (unsigned char **)0;

    copy.dpTitle= (unsigned char *)0;
    copy.dpSubject= (unsigned char *)0;
    copy.dpKeywords= (unsigned char *)0;
    copy.dpComment= (unsigned char *)0;
    copy.dpAuthor= (unsigned char *)0;
    copy.dpHlinkbase= (unsigned char *)0;
    copy.dpFilename= (unsigned char *)0;

    if  ( docCopyFontList( &(copy.dpFontList), &(from->dpFontList) ) )
	{ LDEB(1); docCleanDocumentProperties( &copy ); return -1;	}

    /**/
    copy.dpColors= (RGB8Color *)
			malloc( from->dpColorCount* sizeof(RGB8Color) );
    if  ( ! copy.dpColors )
	{
	XDEB(copy.dpColors);
	docCleanDocumentProperties( &copy ); return -1;
	}
    for ( i= 0; i < from->dpColorCount; i++ )
	{ copy.dpColors[i]= from->dpColors[i]; }
    copy.dpColorCount= from->dpColorCount;

    /**/
    copy.dpAuthors= (unsigned char **)
		    malloc( from->dpAuthorCount* sizeof(unsigned char *) );
    if  ( ! copy.dpAuthors )
	{
	XDEB(copy.dpAuthors);
	docCleanDocumentProperties( &copy ); return -1;
	}
    for ( i= 0; i < from->dpAuthorCount; i++ )
	{ copy.dpAuthors[i]= (unsigned char *)0; }
    copy.dpAuthorCount= from->dpAuthorCount;
    for ( i= 0; i < from->dpAuthorCount; i++ )
	{
	copy.dpAuthors[i]= (unsigned char *)
				    strdup( (char *)from->dpAuthors[i] );
	if  ( ! copy.dpAuthors[i] )
	    {
	    XDEB(copy.dpAuthors[i]);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}

    if  ( from->dpTitle )
	{
	copy.dpTitle= (unsigned char *)strdup( (char *)from->dpTitle );
	if  ( ! copy.dpTitle )
	    {
	    XDEB(copy.dpTitle);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}
    if  ( from->dpSubject )
	{
	copy.dpSubject= (unsigned char *)strdup( (char *)from->dpSubject );
	if  ( ! copy.dpSubject )
	    {
	    XDEB(copy.dpSubject);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}
    if  ( from->dpKeywords )
	{
	copy.dpKeywords= (unsigned char *)strdup( (char *)from->dpKeywords );
	if  ( ! copy.dpKeywords )
	    {
	    XDEB(copy.dpKeywords);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}
    if  ( from->dpComment )
	{
	copy.dpComment= (unsigned char *)strdup( (char *)from->dpComment );
	if  ( ! copy.dpComment )
	    {
	    XDEB(copy.dpComment);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}
    if  ( from->dpAuthor )
	{
	copy.dpAuthor= (unsigned char *)strdup( (char *)from->dpAuthor );
	if  ( ! copy.dpAuthor )
	    {
	    XDEB(copy.dpAuthor);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}
    if  ( from->dpHlinkbase )
	{
	copy.dpHlinkbase= (unsigned char *)strdup( (char *)from->dpHlinkbase );
	if  ( ! copy.dpHlinkbase )
	    {
	    XDEB(copy.dpHlinkbase);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}
    if  ( from->dpFilename )
	{
	copy.dpFilename= (unsigned char *)strdup( (char *)from->dpFilename );
	if  ( ! copy.dpFilename )
	    {
	    XDEB(copy.dpFilename);
	    docCleanDocumentProperties( &copy ); return -1;
	    }
	}

    docCleanDocumentProperties( to );
    *to= copy;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Set the file name in the document properties.			*/
/*									*/
/************************************************************************/

int docPropertiesSetFilename(	DocumentProperties *	dp,
				const char *		filename )
    {
    char *	saved= (char *)0;

    if  ( filename )
	{
	saved= strdup( filename );
	if  ( ! saved )
	    { XDEB(saved); return -1;	}
	}

    if  ( dp->dpFilename )
	{ free( dp->dpFilename );	}

    dp->dpFilename= (unsigned char *)saved;
    return 0;
    }

/************************************************************************/
/*									*/
/*  Change document properties and tell what has been changed.		*/
/*									*/
/************************************************************************/

int docUpdDocumentProperties(	unsigned int *			pChgPask,
				DocumentProperties *		dp,
				unsigned int			updMask,
				const DocumentProperties *	dpNew )
    {
    unsigned int		chgMask;

    PROPmaskCLEAR( &chgMask );

    appSetDocumentGeometry( &(dp->dpGeometry), &(dpNew->dpGeometry),
					    &chgMask, updMask & DGupdALL );

    if  ( PROPmaskISSET( updMask, DPpropSTART_PAGE ) )
	{
	if  ( dp->dpStartPageNumber != dpNew->dpStartPageNumber )
	    {
	    dp->dpStartPageNumber= dpNew->dpStartPageNumber;
	    PROPmaskADD( &chgMask, DPpropSTART_PAGE );
	    }
	}

    if  ( PROPmaskISSET( updMask, DPpropFACING_PAGES ) )
	{
	if  ( dp->dpHasFacingPages != dpNew->dpHasFacingPages )
	    {
	    dp->dpHasFacingPages= dpNew->dpHasFacingPages;
	    PROPmaskADD( &chgMask, DPpropFACING_PAGES );
	    }
	}

    if  ( PROPmaskISSET( updMask, DPpropFOOTNOTE_POSITION ) )
	{
	if  ( dp->dpFootnotePosition != dpNew->dpFootnotePosition )
	    {
	    dp->dpFootnotePosition= dpNew->dpFootnotePosition;
	    PROPmaskADD( &chgMask, DPpropFOOTNOTE_POSITION );
	    }
	}

    if  ( PROPmaskISSET( updMask, DPpropFOOTNOTE_RESTART ) )
	{
	if  ( dp->dpFootnotesRestart != dpNew->dpFootnotesRestart )
	    {
	    dp->dpFootnotesRestart= dpNew->dpFootnotesRestart;
	    PROPmaskADD( &chgMask, DPpropFOOTNOTE_RESTART );
	    }
	}

    if  ( PROPmaskISSET( updMask, DPpropFOOTNOTE_STYLE ) )
	{
	if  ( dp->dpFootnoteNumberStyle != dpNew->dpFootnoteNumberStyle )
	    {
	    dp->dpFootnoteNumberStyle= dpNew->dpFootnoteNumberStyle;
	    PROPmaskADD( &chgMask, DPpropFOOTNOTE_STYLE );
	    }
	}

    if  ( PROPmaskISSET( updMask, DPpropFOOTNOTE_STARTNR ) )
	{
	if  ( dp->dpStartFootnoteNumber != dpNew->dpStartFootnoteNumber )
	    {
	    dp->dpStartFootnoteNumber= dpNew->dpStartFootnoteNumber;
	    PROPmaskADD( &chgMask, DPpropFOOTNOTE_STARTNR );
	    }
	}

    if  ( PROPmaskISSET( updMask, DPpropENDNOTE_POSITION ) )
	{
	if  ( dp->dpEndnotePosition != dpNew->dpEndnotePosition )
	    {
	    dp->dpEndnotePosition= dpNew->dpEndnotePosition;
	    PROPmaskADD( &chgMask, DPpropENDNOTE_POSITION );
	    }
	}

    if  ( PROPmaskISSET( updMask, DPpropENDNOTE_RESTART ) )
	{
	if  ( dp->dpEndnotesRestart != dpNew->dpEndnotesRestart )
	    {
	    dp->dpEndnotesRestart= dpNew->dpEndnotesRestart;
	    PROPmaskADD( &chgMask, DPpropENDNOTE_RESTART );
	    }
	}

    if  ( PROPmaskISSET( updMask, DPpropENDNOTE_STYLE ) )
	{
	if  ( dp->dpEndnoteNumberStyle != dpNew->dpEndnoteNumberStyle )
	    {
	    dp->dpEndnoteNumberStyle= dpNew->dpEndnoteNumberStyle;
	    PROPmaskADD( &chgMask, DPpropENDNOTE_STYLE );
	    }
	}

    if  ( PROPmaskISSET( updMask, DPpropENDNOTE_STARTNR ) )
	{
	if  ( dp->dpStartEndnoteNumber != dpNew->dpStartEndnoteNumber )
	    {
	    dp->dpStartEndnoteNumber= dpNew->dpStartEndnoteNumber;
	    PROPmaskADD( &chgMask, DPpropENDNOTE_STARTNR );
	    }
	}

    if  ( PROPmaskISSET( updMask, DPpropDEFTAB ) )
	{
	if  ( dp->dpTabIntervalTwips != dpNew->dpTabIntervalTwips )
	    {
	    dp->dpTabIntervalTwips= dpNew->dpTabIntervalTwips;
	    PROPmaskADD( &chgMask, DPpropDEFTAB );
	    }
	}

    if  ( PROPmaskISSET( updMask, DPpropANSICPG ) )
	{
	if  ( dp->dpAnsiCodePage != dpNew->dpAnsiCodePage )
	    {
	    dp->dpAnsiCodePage= dpNew->dpAnsiCodePage;
	    PROPmaskADD( &chgMask, DPpropANSICPG );
	    }
	}

    *pChgPask= chgMask; return 0;
    }

