#####################################################################
##
##   Find out how to link statically
##
##   1: From utter stupidity, we only know this for gcc. and very
##	few other systems.
##
#####################################################################

AC_DEFUN(AC_LD_FLAGS_STATIC,
[
    echo Checking for static link flags...

    LD_FLAGS_STATIC=

    #   1
    if  test x_$GCC = x_yes
    then
	LD_FLAGS_STATIC=-static
    else
	case `uname -s` in
	    OSF1)
		LD_FLAGS_STATIC=-non_shared
		;;
	    *)
		# 1
		;;
	esac
    fi


    AC_SUBST(LD_FLAGS_STATIC)dnl
])
#####################################################################
##
##   Look for gtk headers and libraries.
##
#####################################################################

AC_DEFUN(AC_PATH_GTK,
[
    echo Checking for Gtk etc.

    GTK_CFLAGS=
    GTK_LIBS=

    GTK_HEADERS_FOUND=NO
    GTK_LIBS_FOUND=NO

    if  ( gtk-config --cflags ) > /dev/null
    then
	GTK_CFLAGS=`gtk-config --cflags`
	GTK_HEADERS_FOUND=YES
    fi

    if  ( gtk-config --libs ) > /dev/null
    then
	GTK_LIBS=`gtk-config --libs`
	GTK_LIBS_FOUND=YES
    fi

    AC_SUBST(GTK_CFLAGS)dnl
    AC_SUBST(GTK_LIBS)dnl
])
#####################################################################
##
##   Look for libxpm
##
#####################################################################

AC_DEFUN(AC_PATH_XPM,
[
    echo Checking for libxpm...

    XPM_CFLAGS=
    XPM_LIBS=
    HAVE_XPM=NO_XPM

    ac_xpm_includes=NO
    ac_xpm_libraries=NO

    # Includes
    for ac_dir in			\
	/usr/X11R6/include		\
	/usr/local/include		\
	/usr/pkg/include		\
	/usr/local/include/X11R6	\
	/usr/apps/include		\
	../xpm
    do
    if  test -r "$ac_dir/X11/xpm.h"
	then
	    ac_xpm_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in			\
	/usr/X11R6/lib			\
	/usr/local/lib			\
	/usr/pkg/lib			\
	/usr/local/lib/X11R6		\
	/usr/apps/lib			\
	../xpm/lib
    do
    if  test -r "$ac_dir/libXpm.a"
	then
	    ac_xpm_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_xpm_includes
    #echo Libraries: $ac_xpm_libraries

    if  test $ac_xpm_includes != NO
    then
	XPM_CFLAGS=-I$ac_xpm_includes
	HAVE_XPM=HAVE_XPM

	if  test "$XPM_CFLAGS" = "$X_CFLAGS"
	then
	    XPM_CFLAGS=
	fi
    fi

    if  test $ac_xpm_libraries != NO
    then
	XPM_LIBS="-L$ac_xpm_libraries"

	if  test "$XPM_LIBS" = "$X_LIBS"
	then
	    XPM_LIBS=
	fi
    fi

    AC_SUBST(XPM_CFLAGS)dnl
    AC_SUBST(XPM_LIBS)dnl
    AC_SUBST(HAVE_XPM)dnl
])
#####################################################################
##
##   Look for Motif
##
#####################################################################

AC_DEFUN(AC_PATH_XM,
[
    echo Checking for Motif...

    XM_CFLAGS=
    XM_LIBS=
    XM_EXTRA_LIBS=

    MOTIF_HEADERS_FOUND=NO
    MOTIF_LIBS_FOUND=NO

    ac_xm_includes=NO
    ac_xm_libraries=NO

    # Includes
    for ac_dir in			\
	/usr/X11R6/include		\
	/usr/local/include		\
	/usr/dt/include			\
	/opt/SUNWmotif/include		\
	/usr/apps/include		\
	/usr/local/LessTif/include
    do
    if  test -r "$ac_dir/Xm/Xm.h"
	then
	    ac_xm_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in			\
	/usr/X11R6/lib			\
	/usr/local/lib			\
	/usr/dt/lib			\
	/opt/SUNWmotif/lib		\
	/usr/apps/lib			\
	/usr/local/LessTif/lib
    do
    if  test -r "$ac_dir/libXm.a"
	then
	    ac_xm_libraries=$ac_dir
	    break
	fi

    if  test -r "$ac_dir/libXm.so"
	then
	    ac_xm_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_xm_includes
    #echo Libraries: $ac_xm_libraries

    if  test $ac_xm_includes != NO
    then
	XM_CFLAGS=-I$ac_xm_includes
	MOTIF_HEADERS_FOUND=YES

	if  test "$XM_CFLAGS" = "$X_CFLAGS"
	then
	    XM_CFLAGS=
	fi
    fi

    if  test $ac_xm_libraries != NO
    then
	XM_LIBS="-L$ac_xm_libraries"
	MOTIF_LIBS_FOUND=YES

	if  test "$XM_LIBS" = "$X_LIBS"
	then
	    XM_LIBS=
	fi
    fi

    #  Too simple..
    #  AC_CHECK_LIB( Xp, XpStartPage, XM_EXTRA_LIBS="-lXp" )
    if  test -r $ac_xm_libraries/libXp.a
    then
	XM_EXTRA_LIBS="-lXp"
    else
	if  test -r $ac_xm_libraries/libXp.so
	then
	    XM_EXTRA_LIBS="-lXp"
	fi
    fi

    AC_SUBST(XM_CFLAGS)dnl
    AC_SUBST(XM_LIBS)dnl
    AC_SUBST(XM_EXTRA_LIBS)dnl
])
#####################################################################
##
##   Look for libpng
##
#####################################################################

AC_DEFUN(AC_PATH_PNG,
[
    echo Checking for libpng...

    PNG_CFLAGS=
    PNG_LIBS=

    ac_png_includes=NO
    ac_png_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/X11R6/include	\
	/usr/local/include/png	\
	/usr/apps/include	\
	../libpng
    do
    if  test -r "$ac_dir/png.h"
	then
	    ac_png_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/apps/lib		\
	/usr/local/lib/png	\
	/usr/X11R6/lib		\
	../libpng
    do
    if  test -r "$ac_dir/libpng.a"
	then
	    ac_png_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_png_includes
    #echo Libraries: $ac_png_libraries

    if  test $ac_png_includes != NO
    then
	PNG_CFLAGS=-I$ac_png_includes
    fi

    if  test $ac_png_libraries != NO
    then
	PNG_LIBS="-L$ac_png_libraries"
    fi

    AC_SUBST(PNG_CFLAGS)dnl
    AC_SUBST(PNG_LIBS)dnl
])
#####################################################################
##
##   Look for zlib
##
#####################################################################

AC_DEFUN(AC_PATH_ZLIB,
[
    echo Checking for zlib...

    ZLIB_CFLAGS=
    ZLIB_LIBS=

    ac_zlib_includes=NO
    ac_zlib_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/include		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/local/include/zlib	\
	/usr/apps/include	\
	../zlib
    do
    if  test -r "$ac_dir/zlib.h"
	then
	    ac_zlib_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/lib		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/local/lib/zlib	\
	/usr/apps/lib		\
	../zlib
    do
    if  test -r "$ac_dir/libz.a"
	then
	    ac_zlib_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_zlib_includes
    #echo Libraries: $ac_zlib_libraries

    if  test $ac_zlib_includes != NO
    then
	ZLIB_CFLAGS=-I$ac_zlib_includes
    fi

    if  test $ac_zlib_libraries != NO
    then
	ZLIB_LIBS="-L$ac_zlib_libraries"
    fi

    AC_SUBST(ZLIB_CFLAGS)dnl
    AC_SUBST(ZLIB_LIBS)dnl
])
#####################################################################
##
##   Look for libjpeg
##
#####################################################################

AC_DEFUN(AC_PATH_JPEG,
[
    echo Checking for libjpeg...

    JPEG_CFLAGS=
    JPEG_LIBS=
    HAVE_JPEG=NO_JPEG

    ac_jpeg_includes=NO
    ac_jpeg_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/local/include	\
	/usr/include		\
	/usr/pkg/include	\
	/usr/local/include/jpeg	\
	/usr/apps/include	\
	../jpeg
    do
    if  test -r "$ac_dir/jpeglib.h"
	then
	    ac_jpeg_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/local/lib		\
	/usr/lib		\
	/usr/pkg/lib		\
	/usr/local/lib/jpeg	\
	/usr/apps/lib		\
	../jpeg
    do
    if  test -r "$ac_dir/libjpeg.a"
	then
	    ac_jpeg_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_jpeg_includes
    #echo Libraries: $ac_jpeg_libraries

    if  test $ac_jpeg_includes != NO
    then
	HAVE_JPEG=HAVE_JPEG
	JPEG_CFLAGS=-I$ac_jpeg_includes
    fi

    if  test $ac_jpeg_libraries != NO
    then
	JPEG_LIBS="-L$ac_jpeg_libraries"
    fi

    AC_SUBST(JPEG_CFLAGS)dnl
    AC_SUBST(JPEG_LIBS)dnl
    AC_SUBST(HAVE_JPEG)dnl
])
#####################################################################
##
##   Look for libtiff
##
#####################################################################

AC_DEFUN(AC_PATH_TIFF,
[
    echo Checking for libtiff...

    TIFF_CFLAGS=
    TIFF_LIBS=

    ac_tiff_includes=NO
    ac_tiff_libraries=NO

    # Includes
    for ac_dir in		\
	/usr/local/include	\
	/usr/pkg/include	\
	/usr/local/include/tiff	\
	/usr/apps/include	\
	../tiff/libtiff
    do
    if  test -r "$ac_dir/tiffio.h"
	then
	    ac_tiff_includes=$ac_dir
	    break
	fi
    done

    # Libraries
    for ac_dir in		\
	/usr/local/lib		\
	/usr/pkg/lib		\
	/usr/local/lib/tiff	\
	/usr/apps/lib		\
	../tiff/libtiff
    do
    if  test -r "$ac_dir/libtiff.a"
	then
	    ac_tiff_libraries=$ac_dir
	    break
	fi
    done

    #echo Includes : $ac_tiff_includes
    #echo Libraries: $ac_tiff_libraries

    if  test $ac_tiff_includes != NO
    then
	TIFF_CFLAGS=-I$ac_tiff_includes
    fi

    if  test $ac_tiff_libraries != NO
    then
	TIFF_LIBS="-L$ac_tiff_libraries"
    fi

    AC_SUBST(TIFF_CFLAGS)dnl
    AC_SUBST(TIFF_LIBS)dnl
])
#####################################################################
##
##   Give the caller the possibility to interfere with install
##   locations.
##
#####################################################################

AC_DEFUN(AC_INSTALL_LOCATIONS,
[
    dnl Installation locations ..

    AC_PREFIX_DEFAULT("/usr/local")

    if  test x_$prefix = x_NONE
    then
	PREFIX='"'/usr/local'"'
	EXEX_PREFIX='"'/usr/local'"'
	BINDIR='"'/usr/local/bin'"'
    else
	PREFIX='"'$prefix'"'
	EXEX_PREFIX='"'$prefix'"'
	BINDIR='"'$prefix/bin'"'
    fi

    if  test x_$exec_prefix = x_NONE
    then
	: ok
    else
	EXEX_PREFIX='"'$exec_prefix'"'
	BINDIR='"'$exec_prefix/bin'"'
    fi

    case $bindir in
	''|x_NONE)
	    : ok
	    ;;
	\$\{*\}/bin)
	    x_var=`eval echo $bindir`
	    case $x_var in
		NONE/bin)
		    BINDIR='"'/usr/local/bin'"'
		    ;;
		*)
		    BINDIR='"'$x_var'"'
		    ;;
	    esac
	    unset x_var
	    ;;
	*)
	    BINDIR='"'$bindir'"'
	    ;;
    esac

    AC_DEFINE_UNQUOTED( PREFIX, $PREFIX )
    AC_DEFINE_UNQUOTED( EXEC_PREFIX, $EXEC_PREFIX )
    AC_DEFINE_UNQUOTED( BINDIR, $BINDIR )

    AC_SUBST(PREFIX)
    AC_SUBST(EXEC_PREFIX)
    AC_SUBST(BINDIR)
])
#####################################################################
##
##   Choose the GUI thet is used. Relies on settings from the
##   Motif and/or Gtk configuration macros.
##
#####################################################################

AC_DEFUN(AC_CHOOSE_GUI,
[
    echo Choosing a GUI...

    GUI=NONE
    NO_MOTIF=NO
    NO_GTK=NO

    AC_ARG_WITH( MOTIF,
	[  --with-MOTIF            Use Motif/LessTif user interface],
	[
	if  test $withval = yes
	then
	    echo Choosing MOTIF ...

	    if  test	x_$MOTIF_HEADERS_FOUND = x_YES	-a \
			    x_$MOTIF_LIBS_FOUND = x_YES
	    then
		if  test $GUI = NONE
		then
		    : ok
		else
		    echo '############' WARNING '############'
		    echo 'GUI=' $GUI
		fi
	    else
		echo '############' WARNING '############'
		echo 'MOTIF_HEADERS_FOUND=' $MOTIF_HEADERS_FOUND
		echo 'MOTIF_LIBS_FOUND=' $MOTIF_HEADERS_FOUND
	    fi
	    
	    GUI=MOTIF
	else
	    NO_MOTIF=YES
	fi
	]
    )

    AC_ARG_WITH( GTK,
	[  --with-GTK              Use Gtk+ user interface ],
	[
	if  test $withval = yes
	then
	    echo Choosing GTK ...

	    if  test	x_$GTK_HEADERS_FOUND = x_YES	-a \
			    x_$GTK_LIBS_FOUND = x_YES
	    then
		if  test $GUI = NONE
		then
		    : ok
		else
		    echo '############' WARNING '############'
		    echo 'GUI=' $GUI
		fi
	    else
		echo '############' WARNING '############'
		echo 'GTK_HEADERS_FOUND=' $GTK_HEADERS_FOUND
		echo 'GTK_LIBS_FOUND=' $GTK_HEADERS_FOUND
	    fi
	    
	    GUI=GTK
	else
	    NO_GTK=YES
	fi
	]
    )

    if  test	$GUI = NONE				-a \
		$NO_MOTIF = NO				-a \
		x_$MOTIF_HEADERS_FOUND = x_YES		-a \
		x_$MOTIF_LIBS_FOUND = x_YES
    then
	echo Found MOTIF
	GUI=MOTIF
    fi

    if  test	$GUI = NONE				-a \
		$NO_GTK = NO				-a \
		x_$GTK_HEADERS_FOUND = x_YES		-a \
		x_$GTK_LIBS_FOUND = x_YES
    then
	echo Found GTK
	GUI=GTK
    fi

    case $GUI in
    MOTIF)
	AC_SUBST(GUI)
	AC_DEFINE( USE_MOTIF )
	;;
    GTK)
	AC_SUBST(GUI)
	AC_DEFINE( USE_GTK )
	;;
    *)
	echo '############' WARNING '############'
	echo 'GUI=' $GUI
	;;
    esac
])
