/*
 * solve.h - header for solve.c, addresses family-independant resolution
 * functions.
 * $Id: solve.h,v 1.5 2003/01/26 09:09:08 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Rmi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_SOLVE_H

# define __TCPREEN_SOLVE_H
# include <stddef.h> /* size_t */
# ifdef HAVE_SYS_TYPES_H
#  include <sys/types.h> /* might be needed for sys/socket.h */
#endif
# ifdef HAVE_SYS_SOCKET_H
#  include <sys/socket.h> /* might be needed for struct sockaddr */
# endif
# include "getaddrinfo.h" /* NI_MAXHOST, NI_MAXSERV */

# ifdef __cplusplus
extern "C" {
#endif

#define NI_MAXADDRESS NI_MAXHOST + NI_MAXSERV + 2

int secure_getnameinfo(struct sockaddr *addr, size_t addrlen,
	char *nodename, size_t nlen, char *service, size_t slen, int flags);
int getsockaddr(int fd, int flags, int peer, char *buf, size_t len);

# ifdef __cplusplus
}
# endif
#endif

