/*
 * Convenience header for <netdb.h> getaddrinfo() & co modern resolution
 * functions.
 * $Id: getaddrinfo.h,v 1.4 2003/01/26 09:09:08 rdenisc Exp $
 *
 * Feel free to reuse in other GPL programs.
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Rmi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_GETADDRINFO_H
# define __TCPREEN_GETADDRINFO_H

# include <stddef.h>
# ifdef HAVE_SYS_TYPES_H
#  include <sys/types.h>
# endif
# ifdef HAVE_SYS_SOCKET_H
#  include <sys/socket.h>
# endif
# ifdef HAVE_NETDB_H
#  include <netdb.h>
# endif

# if !(defined(HAVE_GAI_STRERROR)  && defined(HAVE_GETNAMEINFO) \
	&& defined(HAVE_GETADDRINFO))

/* GAI error codes */
#  ifndef EAI_BADFLAGS
#   define EAI_BADFLAGS -1
#  endif
#  ifndef EAI_NONAME
#   define EAI_NONAME -2
#  endif
#  ifndef EAI_AGAIN
#   define EAI_AGAIN -3
#  endif
#  ifndef EAI_FAIL
#   define EAI_FAIL -4
#  endif
#  ifndef EAI_NODATA
#   define EAI_NODATA -5
#  endif
#  ifndef EAI_FAMILY
#   define EAI_FAMILY -6
#  endif
#  ifndef EAI_SOCKTYPE
#   define EAI_SOCKTYPE -7
#  endif
#  ifndef EAI_SERVICE
#   define EAI_SERVICE -8
#  endif
#  ifndef EAI_ADDRFAMILY
#   define EAI_ADDRFAMILY -9
#  endif
#  ifndef EAI_MEMORY
#   define EAI_MEMORY -10
#  endif
#  ifndef EAI_SYSTEM
#   define EAI_SYSTEM -11
#  endif


#  if !HAVE_GETNAMEINFO
/*
 * Replacement for getnameinfo().
 */
#   ifndef NI_MAXHOST
#    define NI_MAXHOST	1025
#    define NI_MAXSERV	32
#   endif

#   ifndef NI_NUMERICHOST
#    define NI_NUMERICHOST	0x01
#    define NI_NUMERICSERV	0x02
#    define NI_NOFQDN		0x04
#    define NI_NAMEREQD		0x08
#    define NI_DGRAM		0x10
#   endif
#   define _NI_MASK		NI_NUMERICHOST|NI_NUMERICSERV|NI_NOFQDN|NI_NAMEREQD|NI_DGRAM

#   ifdef __cplusplus
extern "C"
#   endif
int getnameinfo(const struct sockaddr *sa, int salen,
	char *host, int hostlen, char *serv, int servlen, int flags);
#  endif /* if !HAVE_GETNAMEINFO */


#  if !HAVE_GAI_STRERROR
/*
 * Replacement for gai_strerror().
 */
#   ifdef __cplusplus
extern "C"
#   endif
const char *gai_strerror(int errnum);
#  endif /* if !HAVE_GAI_STRERROR */


#  if !HAVE_GETADDRINFO
/*
 * Replacement for getaddrinfo() and freeaddrinfo().
 */
struct addrinfo
{
	int ai_flags;
	int ai_family;
	int ai_socktype;
	int ai_protocol;
	size_t ai_addrlen;
	struct sockaddr *ai_addr;
	char *ai_canonname;
	struct addrinfo *ai_next;
};
#   define AI_PASSIVE		1
#   define AI_CANONNAME		2
#   define AI_NUMERICHOST	4
#   define _AI_MASK		7

#   ifdef __cplusplus
extern "C" {
#   endif
void freeaddrinfo(struct addrinfo *res);
int getaddrinfo(const char *node, const char *serv,
		const struct addrinfo *hints, struct addrinfo **res);
#   ifdef __cplusplus
}
#   endif
#  endif /* if !HAVE_GETADDRINFO */
# endif


#endif /* ifndef __RDC_GETADDRINFO_H */

