/*
 * socketinfo.h - C header for socketinfo.c
 * socket creation functions on top of getaddrinfo()
 */

/**********************************************************************
 *  Copyright (C) 2002 Rmi Denis-Courmont.                           *
 *  This program is free software; you can redistribute and/or modify *
 *  it under the terms of the GNU General Public License as published *
 *  by the Free Software Foundation; version 2 of the license.        *
 *                                                                    *
 *  This program is distributed in the hope that it will be useful,   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.              *
 *  See the GNU General Public License for more details.              *
 *                                                                    *
 *  You should have received a copy of the GNU General Pulic License  *
 *  along with this program; if not, you can get it from:             *
 *  http://www.gnu.org/copyleft/gpl.html                              *
 *                                                                    *
 *  You are highly encouraged to submit your modifications to         *
 *  remi@simphalempin.com for possible inclusion in the official      *
 *  distribution. By doing so, and unless otherwise stated, you give  *
 *  Rmi Denis-Courmont an unlimited, non-exclusive right to modify,  *
 *  reuse and/or relicense the code.                                  *
 **********************************************************************/

#ifndef _RDC_SOCKETINFO_H
# define _RDC_SOCKETINFO_H

# ifdef HAVE_CONFIG_H
#  include <config.h>
# endif
# ifdef HAVE_SYS_TYPES
#  include <sys/types.h>
# endif
# ifdef HAVE_NETDB_H
#  include <netdb.h>
# endif
# ifdef HAVE_UNISTD_H
#  include <sys/time.h>
#  include <unistd.h>
# endif

typedef int *fd_array;

struct sockhostinfo {
	char hostname[NI_MAXHOST], service[NI_MAXSERV];
	int family, socktype, protocol;
};

# ifdef __cplusplus
extern "C" {
# endif

int socket_from_addrinfo(const struct addrinfo *info);
int socket_listen(fd_array *arrayptr, const struct addrinfo *hints,
		const char *locname, const char *locserv);
void fd_freearray(fd_array array);
int fd_closearray(fd_array array);
int fd_arraytoset(const int *array, fd_set *set);
int fd_findfromset(const int *array, fd_set *set);
int accept_array(const fd_array array);
int socket_connect(int *fd, const struct addrinfo *hints,
		const char *destname, const char *destserv);
void socket_perror(int errno, const char *nodename,
		const char *service);
int sockhostinfo_listen(fd_array *array,
			const struct sockhostinfo *hostinfo);
int sockhostinfo_connect(int *fd, const struct sockhostinfo *hostinfo);
void sockhostinfo_perror(int errno, const struct sockhostinfo *info);

# ifdef __cplusplus
}
# endif
#endif

