/*
 * log.h - log files handling structures
 */

/**********************************************************************
 *  Copyright (C) 2002 Rmi Denis-Courmont.                           *
 *  This program is free software; you can redistribute and/or modify *
 *  it under the terms of the GNU General Public License as published *
 *  by the Free Software Foundation; version 2 of the license.        *
 *                                                                    *
 *  This program is distributed in the hope that it will be useful,   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.              *
 *  See the GNU General Public License for more details.              *
 *                                                                    *
 *  You should have received a copy of the GNU General Pulic License  *
 *  along with this program; if not, you can get it from:             *
 *  http://www.gnu.org/copyleft/gpl.html                              *
 *                                                                    *
 *  You are highly encouraged to submit your modifications to         *
 *  remi@simphalempin.com for possible inclusion in the official      *
 *  distribution. By doing so, and unless otherwise stated, you give  *
 *  Rmi Denis-Courmont an unlimited, non-exclusive right to modify,  *
 *  reuse and/or relicense the code.                                  *
 **********************************************************************/

#ifndef __LOG_H

# define __LOG_H
# ifdef HAVE_CONFIG_H
#  include <config.h>
# endif

# include <stdio.h>

struct logfile {
	FILE *stream;
	int (*write)(const void *, int, FILE *);
	int opened;
	struct logfile *next;
};
	

# ifdef __cplusplus
extern "C" {
#endif

/*
 * Adds a stream to log files list.
 * Returns 0 on success, -1 on error (not enough memory) or if stream
 * is NULL.
 */
int logfile_add(struct logfile **list, FILE *stream, int opened,
		int (*logwrite)(const void *, int, FILE *));

/*
 * Closes all log files from a list, and releases allocated memory.
 */
int logfile_closeall(struct logfile *list);

# ifdef __cplusplus
}
# endif
#endif

