/*
 * getaddrinfo.h - header for getaddrinfo.c
 * IPV4-only replacement for getaddrinfo/getnameinfo
 */

/**********************************************************************
 *  Copyright (C) 2002 Rmi Denis-Courmont.                           *
 *  This program is free software; you can redistribute and/or modify *
 *  it under the terms of the GNU General Public License as published *
 *  by the Free Software Foundation; version 2 of the license.        *
 *                                                                    *
 *  This program is distributed in the hope that it will be useful,   *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.              *
 *  See the GNU General Public License for more details.              *
 *                                                                    *
 *  You should have received a copy of the GNU General Pulic License  *
 *  along with this program; if not, you can get it from:             *
 *  http://www.gnu.org/copyleft/gpl.html                              *
 *                                                                    *
 *  You are highly encouraged to submit your modifications to         *
 *  remi@simphalempin.com for possible inclusion in the official      *
 *  distribution. By doing so, and unless otherwise stated, you give  *
 *  Rmi Denis-Courmont an unlimited, non-exclusive right to modify,  *
 *  reuse and/or relicense the code.                                  *
 **********************************************************************/

#ifndef __RDC_GETADDRINFO_H
# define __RDC_GETADDRINFO_H

# if !(defined(HAVE_GAI_STRERROR)  && defined(HAVE_GETNAMEINFO) \
	&& defined(HAVE_GETADDRINFO) && defined(HAVE_STRUCT_SOCKADDR_STORAGE))
	
#  ifdef HAVE_SYS_TYPES_H
#   include <sys/types.h>
#  endif
#  ifdef HAVE_SYS_SOCKET_H
#   include <sys/socket.h>
#  endif
#  ifdef HAVE_NETDB_H
#   include <netdb.h>
#  endif

#  ifndef EAI_BADFLAGS
#   define EAI_BADFLAGS -1
#  endif
#  ifndef EAI_NONAME
#   define EAI_NONAME -2
#  endif
#  ifndef EAI_AGAIN
#   define EAI_AGAIN -3
#  endif
#  ifndef EAI_FAIL
#   define EAI_FAIL -4
#  endif
#  ifndef EAI_NODATA
#   define EAI_NODATA -5
#  endif
#  ifndef EAI_FAMILY
#   define EAI_FAMILY -6
#  endif
#  ifndef EAI_SOCKTYPE
#   define EAI_SOCKTYPE -7
#  endif
#  ifndef EAI_SERVICE
#   define EAI_SERVICE -8
#  endif
#  ifndef EAI_ADDRFAMILY
#   define EAI_ADDRFAMILY -9
#  endif
#  ifndef EAI_MEMORY
#   define EAI_MEMORY -10
#  endif
#  ifndef EAI_SYSTEM
#   define EAI_SYSTEM -11
#  endif

#  if !HAVE_GETNAMEINFO
/*
 * Replacement for getnameinfo().
 */
#   define NI_MAXHOST	1025
#   define NI_MAXSERV	32

#   define NI_NUMERICHOST	0x01
#   define NI_NUMERICSERV	0x02
#   define NI_NOFQDN		0x04
#   define NI_NAMEREQD		0x08
#   define NI_DGRAM		0x10
#   define _NI_MASK		0x1f

#   ifdef __cplusplus
extern "C"
#   endif
int getnameinfo(const struct sockaddr *sa, int salen,
	char *host, int hostlen, char *serv, int servlen, int flags);
#  endif /* if !HAVE_GETNAMEINFO */

#  if !HAVE_GAI_STRERROR
/*
 * Replacement for gai_strerror().
 */
#   ifdef __cplusplus
extern "C"
#   endif
const char *gai_strerror(int errnum);
#  endif /* if !HAVE_GAI_STRERROR */

#  if !HAVE_STRUCT_SOCKADDR_STORAGE
struct sockaddr_storage {
	union {
		struct sockaddr __sa;
		char __largespace[128];
	} __sas;
};
#  endif

#  if !HAVE_GETADDRINFO
/*
 * Replacement for getaddrinfo() and freeaddrinfo().
 * FIXME
 */
#   error Not implemented yet!
#  endif /* if !HAVE_GETADDRINFO */

#  define USE_GETADDRINFO_STUB 1
# else
#  undef USE_GETADDRINFO_STUB
# endif

#endif /* ifndef __RDC_GETADDRINFO_H */

