[comment {-*- tcl -*- doctools manpage}]
[comment {$Id: logger.man,v 1.2 2003/01/19 07:58:44 andreas_kupries Exp $}]
[manpage_begin logger n 0.1.0]
[moddesc {Object Oriented logging facility}]
[titledesc {System to control logging of events.}]
[require Tcl 8]
[require logger [opt 0.1.0]]
[description]

[para]

The [package logger] package provides a flexible system for logging messages
from different services, at priority levels, with different commands.

[para]

To begin using the logger package, we do the following:

[para]

[example {
    package require logger
    set log [logger::init myservice]
    ${log}::notice "Initialized myservice logging"

    ... code ...

    ${log}::notice "Ending myservice logging"
    ${log}::destroy
}]

[para]

In the above code, after the package is loaded, the following things
happen:

[list_begin definitions]

[call [cmd logger::init] [arg service]]

Initializes the service [arg service] for logging.  The service names
are actually Tcl namespace names, so they are seperated with '::'.

When a logger service is initalized, it "inherits" properties from its
parents.  For instance, if there were a service [term foo], and
we did a [cmd logger::init] [arg foo::bar] (to create a [term bar]
service underneath [term foo]), [term bar] would copy the current
configuration of the [term foo] service, although it would of
course, also be possible to then seperately configure [term bar].

[call [cmd logger::services]]

Returns a list of all the available services.

[call [cmd logger::enable] [arg level]]

Globally enables logging at or "above" the given level.  Levels are
[const debug], [const info], [const notice], [const warn], [const error],
[const critical].

[call [cmd logger::disable] [arg level]]

Globally disables logging at or "below" the given level.  Levels are
those listed above.

[call [cmd \${log}::debug] [arg message]]
[call [cmd \${log}::info] [arg message]]
[call [cmd \${log}::notice] [arg message]]
[call [cmd \${log}::warn] [arg message]]
[call [cmd \${log}::error] [arg message]]
[call [cmd \${log}::critical] [arg message]]

These are the commands called to actually log a message about an
event.  [var \${log}] is the variable obtained from [cmd logger::init].

[call [cmd \${log}::enable] [arg level]]

Enable logging, in the service referenced by [var \${log}], and its
children.

[call [cmd \${log}::disable] [arg level]]

Disable logging, in the service referenced by [var \${log}], and
its children.

[call [cmd \${log}::logproc] [arg level] [arg argname] [arg body]]

This is a command to define a command that will perform the actual
logging for a given level.  The logger package ships with default
commands for all log levels, but with [cmd logproc] it is possible to
replace them with custom code.  This would let you send your logs over
the network, to a database, or anything else.  For example:

[example {
    ${log}::logproc notice txt {
	puts $netlog "Notice: $txt"
    }
}]

[call [cmd \${log}::services]]

Returns a list of all the registered logging services.

[call [cmd \${log}::delete]]

This command deletes a particular logging service, and its children.
You must call this to clean up the resources used by a service.

[list_end]

[section IMPLEMENTATION]

The logger package is implemented in such a way as to optimize (for
Tcl 8.4 and newer) log procedures which are disabled.  They are
aliased to a proc which has no body, which is compiled to a no op in
bytecode.  This should make the peformance hit minimal.  If you really
want to pull out all the stops, you can replace the ${log} token in
your code with the actual namespace and command (${log}::warn becomes
::logger::tree::myservice::warn), so that no variable lookup is done.
This puts the performance of disabled logger commands very close to no
logging at all.

[para]

The "object orientation" is done through a hierarchy of namespaces.
Using an actual object oriented system would probably be a better way
of doing things, or at least provide for a cleaner implementation.

[para]

The service "object orientation" is done with namespaces.

[keywords logger log service {log level}]
[manpage_end]
