[manpage_begin textutil::split n 0.7]
[moddesc   {Text and string utilities, macro processing}]
[titledesc {Procedures to split texts}]
[require Tcl 8.2]
[require textutil::split [opt 0.7]]
[description]

The package [package textutil::split] provides commands that split
strings by size and arbitrary regular expressions.

[para]

The complete set of procedures is described below.

[list_begin definitions]

[call [cmd ::textutil::split::splitn] [arg string] [opt [arg len]]]

This command splits the given [arg string] into chunks of [arg len]
characters and returns a list containing these chunks. The argument
[arg len] defaults to [const 1] if none is specified. A negative
length is not allowed and will cause the command to throw an
error. Providing an empty string as input is allowed, the command will
then return an empty list. If the length of the [arg string] is not an
entire multiple of the chunk length, then the last chunk in the
generated list will be shorter than [arg len].

[call [cmd ::textutil::split::splitx] [arg string] [opt [arg regexp]]]

This command splits the [arg string] and return a list. The string is
split according to the regular expression [arg regexp] instead of a
simple list of chars.

Note that if you parentheses are added into the [arg regexp], the
parentheses part of separator will be added into the result list as
additional element. If the [arg string] is empty the result is the
empty list, like for [cmd split]. If [arg regexp] is empty the
[arg string] is split at every character, like [cmd split] does.

The regular expression [arg regexp] defaults to "[lb]\\t \\r\\n[rb]+".

[list_end]


[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph textutil] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.


[see_also regexp(n) split(n) string(n)]
[keywords string {regular expression} split]
[manpage_end]
