[comment {-*- tcl -*- doctools manpage}]
[manpage_begin doctools::changelog n 1]
[copyright {2003-2008 Andreas Kupries <andreas_kupries@users.sourceforge.net>}]
[moddesc   {Documentation tools}]
[titledesc {Processing text in Emacs ChangeLog format}]
[require Tcl 8.2]
[require textutil]
[require doctools::changelog [opt 1]]
[description]

This package provides Tcl commands for the processing and reformatting
of text in the [file ChangeLog] format generated by [syscmd emacs].


[section API]

[list_begin definitions]

[call [cmd ::doctools::changelog::scan] [arg text]]

The command takes the [arg text] and parses it under the assumption
that it contains a ChangeLog as generated by [syscmd emacs]. It
returns a data structure describing the contents of this ChangeLog.

[para]

This data structure is a list where each element describes one entry
in the ChangeLog. Each element/entry is then a list of three elements
describing the date of the entry, its author, and the comments made,
in this order. The last item in each element/entry, the comments, is a
list of sections. Each section is described by a list containing two
elements, a list of file names, and a string containing the true
comment associated with the files of the section.

[para]
[example {
    {
	{
	    date
	    author
	    {
		{
		    {file ...}
		    commenttext
		}
		...
	    }
	}
	{...}
    }
}]


[call [cmd ::doctools::changelog::toDoctools] [arg title] [arg module] [arg version] [arg entries]]

This command converts the pre-parsed ChangeLog [arg entries] as
generated by the command [cmd ::doctools::changelog::scan] into a
document in [term doctools] format and returns it as the result of the
command.

[para]

The other three arguments supply the information for the header of
that document which is not available from the changelog itself.


[call [cmd ::doctools::changelog::merge] [arg entries]...]

Each argument of the command is assumed to be a pre-parsed Changelog
as generated by the command [cmd ::doctools::changelog::scan]. This
command merges all of them into a single structure, and collapses
multiple entries for the same date and author into a single entry. The
new structure is returned as the result of the command.

[list_end]

[section {BUGS, IDEAS, FEEDBACK}]

This document, and the package it describes, will undoubtedly contain
bugs and other problems.

Please report such in the category [emph doctools] of the
[uri {http://sourceforge.net/tracker/?group_id=12883} {Tcllib SF Trackers}].

Please also report any ideas for enhancements you may have for either
package and/or documentation.

[keywords changelog emacs doctools]
[manpage_end]
