/***************************************************************************
                          timer.h  -  description
                             -------------------
    begin                : Fre Mai 17 2002
    copyright            : (C) 2002 by Thomas Friedrichsmeier
    email                : tfry@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TIMER_H
#define TIMER_H

#include "event.h"
#include "timedobject.h"

class State;

/**This class represents a timer as a level object. It is based on Event and essentially behaves like an Event that does not fire immediately.
  *@author Thomas Friedrichsmeier
  */

class Timer : public Event, public TimedObject  {
public: 
	Timer(const QDomElement *description, Level *parent);
	~Timer();
private:
/** Reads in the description for this timer */
	void read_timer (const QDomElement *description);
/** Timer id; mostly a dummy var. */
	int timer_id;
/** The state that controls, whether timer loops (automatically starts over) */
	State *loop_state;
/** The timing intervall */
	int timer_period;
/** Whether triggering the timer while it is still counting down will reset the timer */
	bool trigger_resets;
/** Whether triggering the timer while it is still counting down will stop the timer */
	bool trigger_stops;
friend class Level;
/** Whether the timer should be triggered intially (when the levels starts) */
	bool trigger_initially;
protected:
/** Sets off timer activity */
	void trigger ();
/** Called when the countdown is reached */
	void timerTick (int id);
};

#endif
