/***************************************************************************
                          timemanager.cpp  -  description
                             -------------------
    begin                : Sun Dec 23 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "defines.h"
#include "timemanager.h"


#include "cdp.h"
#include <qstring.h>


TimeManager::TimeManager(int num_timers, int base_intervall, Cdp *cdpp){

	max_timers = num_timers;
	base_ti = base_intervall;

	timers = new Timer [max_timers+1];
	free_ids = new int [max_timers];

	for (int i = 0; i <= max_timers; i++) {
		timers[i].to = 0;
		timers[i].increase = 0;
		timers[i].score = 0;
		
		free_ids[i] = i;
	}
	active_timers = 0;
	
	cdp = cdpp;

	resume ();	
}

TimeManager::~TimeManager(){
	pause ();
	delete [] timers;
	delete [] free_ids;
}

void TimeManager::timerEvent(QTimerEvent * e) {
// TODO: better efficiency
	for (int i = 0; i <= max_timers; i++) {
		if (timers[i].increase) {
			timers[i].score += timers[i].increase;
			while (timers[i].score >= 1000) {
				timers[i].score -= 1000;
				timers[i].to->timerTick (i);
			}
		}
	}
}

/** Pauses ALL timers */
void TimeManager::pause (){
	QObject::killTimers ();      // merely kills the base-timer -> no more processing of timerEvent
}

/** Resumes all timers */
void TimeManager::resume (){
	pause ();			// just in case...
	QObject::startTimer (base_ti);
}

/** Starts a timer for TimedObject to with interval timer_period msec, returning id assigned to this timer.
	Returned ids are always in the range of 0 .. MAX_TIMERS */
int TimeManager::startTimer (TimedObject *to, int timer_period) {
	QString debug;

	int id = -1;
	if ((to != 0) && (timer_period > 0)) {
		if (active_timers < (max_timers-1)) {
			id = free_ids[active_timers++];
			timers[id].to = to;
			timers[id].increase = (1000 * base_ti) / timer_period;	//  * 1000 is to give better accuracy (using ints)
/*			debug.setNum (active_timers);
			cdp->debug_msg ( "New Timer. Now " + debug + "timers active", 2);
			debug.setNum (timer_period);
			cdp->debug_msg ( "Timer_Period is: " + debug, 2);
			debug.setNum (timers[id].increase);
			cdp->debug_msg ( "Increase is: " + debug, 2);
			debug.setNum (id);
			cdp->debug_msg ( " Id is: " + debug, 2); */
		} else {
			cdp->debug_msg ("Timer Limit exceeded!", 1, 0);
		}
	}
	return id;
}

/** Dirty hack: set a timer to be checked at the very end of the list. No sanity checks. Any previous timer at this
	place gets deleted without notice! */
int TimeManager::setLastTimer (TimedObject *to, int timer_period) {
	timers[max_timers].to = to;
	timers[max_timers].increase = (1000 * base_ti) / timer_period;

	return max_timers;
}

/** Kills a timer by its id */
void TimeManager::killTimer (int id) {
	if (timers[id].increase) {		// check whether timer exists (does NOT check, whether timer belongs to caller)
		timers[id].to = 0;
		timers[id].increase = timers[id].score = 0;	// free-timer-id-indexing is done in timerEvent

		free_ids[--active_timers] = id;
	}
}

/** Kills all timers for a specified object (slower) */
void TimeManager::killTimers (TimedObject *to) {
	for (int i = 0; i < max_timers; i++) {
		if (timers[i].to == to) {
			this->killTimer (i);		// avoid confusion with QObject::killTimer (int)
		}
	}
}

/** Kills the special last timer */
void TimeManager::killLastTimer () {
	timers[max_timers].to = 0;
	timers[max_timers].increase = timers[max_timers].score = 0;
}
