/***************************************************************************
                          taxipilotapp.h  -  description
                             -------------------
    begin                : Sun Aug 12 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAXIPILOTAPP_H
#define TAXIPILOTAPP_H

#include <qwidget.h>
#include <qmap.h>

#include <kmainwindow.h>
#include <kaction.h>

#if KDE_VERSION < 310
	// can't be compatible on KAccel!!!
	#undef KDE_NO_COMPAT
	#include <kaccel.h>
	#ifdef NEW_KDE
	#define KDE_NO_COMPAT
	#endif
#else
	#include "kshortcut.h"
#endif

#include "taxipilot.h"

/**
  *@author Thomas Friedrichsmeier
  */

/** All this class is currently responsible for is the creation of the menubar. All the actual work
is done by Taxipilot */
class TaxipilotApp:public KMainWindow {
  Q_OBJECT public:
	TaxipilotApp(QWidget * parent = 0, const char *name = 0);
	~TaxipilotApp();
  /** Reads the Acclerator-keys into a QMap. Called at initialization and from configureKeys (). */
  void readKeys ();

	KAction *gameNew, *gamePause, *gameAbort;
  /** Taxipilot reads this */
	QString ack_key_name;
  private:
  /** Our beloved child */
	 Taxipilot * tp;

#if KDE_VERSION < 310
	enum Action { Up, Left, Down, Right, Acknowledge, Flaps };
	KAccel *accel;
	QMap < int, Action > actions;
#else
	KShortcut SUp, SDown, SLeft, SRight;
	KActionCollection *gameActions;
#endif

  protected:
  /** No descriptions */
	void keyPressEvent(QKeyEvent * e);
  /** We need this in combination with the above handler to work around slow auto-repeats:
	pressed keys are stored in (int) current_key, until they get released. Current-key is
	parsed by do_chores. Of course this only allows us one pressed key at a time, but that's
	just fine for now. */
	void keyReleaseEvent(QKeyEvent * e);
  /** No descriptions */
 bool queryExit ();
	private slots:				// Private slots
  /** Calls up the key-Bindings-Dialog and sanity-checks
the settings */
	void configureKeys();
public slots: // Public slots
  /** No descriptions */
  void changePrefs();
  /** This slot is in here and not in the Taxi-class, since the Taxi-class is not QObject-derived. */
  void slotFlaps();
  /** This slot is in here and not in the Message-class, because the message-class is not QObject-derived. */
  void slotAcknowledge();
signals: // Signals
  /** No descriptions */
  void ack_key_pressed();
};

#endif
