/***************************************************************************
                          message.cpp  -  description
                             -------------------
    begin                : Wed Nov 28 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "defines.h"

#include "message.h"

#include <qcanvas.h>
#include <qstring.h>
#include <qfont.h>
#include <qfontinfo.h>
#include <qrect.h>
#include <qobject.h>

#include <klocale.h>

#include "taxipilot.h"
#include "taxipilotapp.h"
#include "cdp.h"

Message::Message(Taxipilot * parent, QCanvasView *p_view) {
	view = p_view;	
	tp = parent;
	cdp = tp->cdp;
	phase = 4;			// which is the phase, in which the two text-sprites are not existent. See destructor

	tm = tp->pause_tm; 	// messages get displayed during game pause only
}

Message::~Message(){
	if (phase != 4) {
		delete ack_sprite;
		delete message_sprite;
	}
}

void Message::display_message (QString & message, QString & ack_key) {
	phase = 0;

	QFont ack_font(SPACE_TEXT_FONT, SPACE_TEXT_FONT_SIZE);
	ack_sprite = new QCanvasText ( i18n ( "Press '" ) + ack_key + "'...", ack_font, view->canvas ());
	ack_sprite->setColor(Qt::SPACE_TEXT_COLOR);
	ack_sprite->setTextFlags(Qt::AlignHCenter | Qt::AlignTop);
	ack_sprite->setZ(MESSAGE_Z);

	QFont message_font(MESSAGE_FONT);
	message_sprite = new QCanvasText (message, message_font, view->canvas ());
	message_sprite->setColor(Qt::MESSAGE_COLOR);
	message_sprite->setTextFlags(Qt::AlignHCenter | Qt::AlignBottom);
	message_sprite->setZ(MESSAGE_Z);

// Calculate message_font-size
	int i = 0;					// determine max text-size
	QRect bound;
	do {

		do {					// get next font-size that can be displayed reasonably
			message_font.setPointSize(MESSAGE_FONT_SIZE - i);
			i += 1;
		} while ((i < (MESSAGE_FONT_SIZE - 6)) && (!QFontInfo::QFontInfo(message_font).exactMatch()));

		message_sprite->setFont(message_font);
		bound = message_sprite->boundingRect();	// and check, whether message fits with this font-size.
	} while ((i < (MESSAGE_FONT_SIZE - 6))
			 && ((bound.width() > view->width()) || (bound.height() > (view->height() / 2))));

// Optimize Canvas-Chunksize
	old_chunk_size = view->canvas()->chunkSize ();
	view->canvas()->retune ( 16 + ((int) ((bound.width () + 4* bound.height()) / 5) / 16) * 16 );

// Move the texts to bottom center of view
	message_sprite->move(0, (view->height() + (bound.height() / 2)) + view->contentsY ());
	// coping with Qt3 weirdness: handler does not seem to be always center anymore
	message_sprite->moveBy ( ((view->width() / 2) + view->contentsX ()) - (message_sprite->boundingRect().left () + message_sprite->boundingRect().width () / 2), 0 );
	text_dest_mid = (view->height() / 2) + view->contentsY ();
	text_dest_top = view->contentsY () - (bound.height() / 2);
	message_sprite->show();

	bound = ack_sprite->boundingRect();
	ack_sprite->move((view->width() / 2) + view->contentsX (), (view->height() + (bound.height() / 2)) + view->contentsY ());

	message_sprite->setYVelocity (- TEXT_SPEED/cdp->fps () );
	ack_sprite->setYVelocity (- 2 * TEXT_SPEED/cdp->fps () );

	tm->startTimer (this, 1000/cdp->fps ());
}

void Message::timerTick(int id) {

	if (message_sprite->y() > text_dest_mid) {
		message_sprite->advance (1);
	} else {
		if (!phase) {
			phase = 1;
			ack_sprite->show ();
		} else if (phase == 1) {
			ack_sprite->advance (1);
			if (ack_sprite->y() < (text_dest_mid + 20)) {
				phase = 2;
			}
		} else if (phase == 3) {
			message_sprite->advance (1);
			ack_sprite->advance (1);
			if ((ack_sprite->y() < -20) && (message_sprite->y() < text_dest_top)) {
				ack_sprite->hide();
				message_sprite->hide();
				delete ack_sprite;
				delete message_sprite;
				phase = 4;
				tm->killTimers (this);
				tp->do_event_after_message ();
				view->canvas ()->retune (old_chunk_size);
			}
		}
	}
	if (phase != 2) {
		view->canvas ()->update ();
	}
}

/** Message was acknowledged */
void Message::acknowledged(){
	if (phase < 3) {
		phase = 3;
		ack_sprite->show ();	// might not have been shown yet
	}
}

/** Kills any message that might still be acitve (called when game gets aborted) */
void Message::kill (){
	if (phase != 4) {
		delete ack_sprite;
		delete message_sprite;
		tm->killTimers (this);
		view->canvas ()->retune (old_chunk_size);
		phase = 4;
	}
}
