/***************************************************************************
                          event.h  -  description
                             -------------------
    begin                : Fri Nov 23 2001
    copyright            : (C) 2001,2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EVENT_H
#define EVENT_H

#include <qstring.h>
#include <qstrlist.h>

class QDomElement;
class Level;
class Cdp;
class State;
class Conditional;

/**An abstract event. Takes care of setting all the associated state
and / or triggering other events
  *@author Thomas Friedrichsmeier
  */

class Event {
public: 
	Event(const QDomElement *description, Level *parent);
	virtual ~Event();
/** Triggers this event */
	virtual void trigger();
/** Tells the event, that it can now resolve it's child events. Called by Level, when
all event-declarations have been read. */
	void resolve_now ();
friend class Timer;
private:
/** The parent level */
	Level * level;
/** The cdp */
	Cdp *cdp;
/** The conditions, this Event depends on to become active */
	Conditional *conditional;
/** The conditions that are going to be changed */
	struct Changes {
/** The state that is to be changed */
		State *state;
/** How it is to be changed (-1 off; 1 on; 0 toggle) */
		int change_type;
	} *changes;
/** The events that are to be fired */
	Event **child_events;
/** The child_events, before they have been resolved */
	QStrList child_event_idents;
/** How many changes, child_events are there? */
	int num_changes, num_child_events;
/** Does this Event depend on something? */
	bool has_conditional;
/** used to prevent recursion */
	bool active;

friend class Level;

/** Identification-string for this event */
	QString ident;
private: // Private methods
/** Reads in the description for this event */
	void read_event (const QDomElement *description);
};

#endif
