/***************************************************************************
                          conditional.h  -  description
                             -------------------
    begin                : Fri Nov 23 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONDITIONAL_H
#define CONDITIONAL_H


/**A conditional is basically a list of states and a the required state (on/off) of those states
+ a member function checking whether this list of conditions is met.
  *@author Thomas Friedrichsmeier
  */

class QDomElement;
class Level;
class Cdp;
class State;

class Conditional {
public: 
	Conditional(const QDomElement *description, Level *level_p);
	~Conditional();
  /** Returns, whether the conditions are met */
  bool fulfilled ();
  /** Reads in the configuration for this conditional */
  void read_conditional (const QDomElement *description);
private:
	struct Condition {
/** State to be checked */
		State *state;
/** Condition to be checked against */
		bool required;	
	} * conditions;
/** Number of conditions to be checked */
	int num_conditions;
/** Pointer to the cdp */
	Cdp *cdp;
/** Pointer to the level */
	Level *level;
};

#endif
