/***************************************************************************
                          conditional.cpp  -  description
                             -------------------
    begin                : Fri Nov 23 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "defines.h"

#include "conditional.h"

#include <qdom.h>

#include "cdp.h"
#include "state.h"
#include "level.h"

Conditional::Conditional(const QDomElement *description, Level *level_p){
	level = level_p;
	cdp = level_p->cdp;
	read_conditional (description);
}

Conditional::~Conditional(){
	if (num_conditions) {delete [] conditions;}
}

/** Returns, whether the conditions are met */
bool Conditional::fulfilled (){
	for (int i = 0; i < num_conditions; i++) {
		if (conditions[i].state->isSet () != conditions[i].required) {
			return (false);
		}
	}
	return (true);
}

/** Reads in the configuration for this conditional */
void Conditional::read_conditional (const QDomElement *description){

	QDomNodeList list;
	QDomNode n;
	QDomElement e;

	list = cdp->get_node_list("requires", *description, 1, -1, 1, 2);
        conditions = new Condition [list.length()];
	num_conditions = 0;
	n = list.item(0);

	while (!n.isNull()) {		// get all data for this conditional
		e = n.toElement();

		QString dummy = cdp->get_string_attribute ("state", e, "a state", 1);
	        conditions[num_conditions].state = level->resolve_state (dummy);
		dummy = cdp->get_multi_choice_attribute ("to_be", e, "on;off", "off", 3);
		if (dummy == "on") {
			conditions[num_conditions].required = true;
		} else {
			conditions[num_conditions].required = false;
		}

		n = n.nextSibling();
		num_conditions++;
	}

}
