/***************************************************************************
                          timemanager.h  -  description
                             -------------------
    begin                : Sun Dec 23 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TIMEMANAGER_H
#define TIMEMANAGER_H

#include <qobject.h>

#include <qlist.h>

#include "timedobject.h"

/**This class provides time-management similar to that of QObject-timers.
The difference is basically, that there is only this one class with an actual
timer (at a high resolution), that emulates timer-events for all the
objects that make use of it. Hopefully, this save a few resources.
  *@author Thomas Friedrichsmeier
  */

class TimedObject;
class Cdp;

class TimeManager : public QObject  {
public: 
	TimeManager(int num_timers, int base_intervall, Cdp *cdpp);
	~TimeManager();

/** Starts a timer for TimedObject to with interval timer_period msec, returning id assigned to this timer.
	Returned ids are always in the range of 0 .. MAX_TIMERS */
	int startTimer (TimedObject *to, int timer_period);
/** Dirty hack: set a timer to be checked at the very end of the list. No sanity checks. Any previous timer at this
	place gets deleted without notice! */
	int setLastTimer (TimedObject *to, int timer_period);
/** Kills a timer by its id */
	void killTimer (int id);
/** Kills all timers for a specified object (slower). Does not kill the special last timer */
	void killTimers (TimedObject *to);
/** Kills the special last timer */
	void killLastTimer ();

/** Resumes all timers */
	void resume ();
/** Pauses ALL timers */
	void pause ();

protected:					// Protected methods
	/** This catches the ticks of the actual timer */
	void timerEvent(QTimerEvent * e);
private:

	struct Timer {
		TimedObject *to;
		int increase;
		int score;
	} *timers;

/** Stores a list of free timer-ids */
	int *free_ids;
/** How many timers there are currently */
	int active_timers;

	int max_timers;
	int base_ti;

	Cdp *cdp;
};

#endif
