/***************************************************************************
                          taxipilotapp.cpp  -  description
                             -------------------
    begin                : Sun Aug 12 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "defines.h"

#include <kstdaction.h>
#include <kkeydialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kmessagebox.h>

#include "taxipilotapp.h"
#include "preferences.h"
#include "message.h"
#include "cdp.h"
#include "kaction.h"

#include <qpixmapcache.h>

TaxipilotApp::TaxipilotApp(QWidget * parent, const char *name):KMainWindow(parent, name)
{
	tp = new Taxipilot(this);
	setCentralWidget(tp);

// create the menubar
	gameNew = KStdAction::openNew(tp, SLOT(newGame()), actionCollection(), "game_new");
	gameAbort = KStdAction::close(tp, SLOT(ask_abortGame()), actionCollection(), "game_close");
	gameAbort->setEnabled(false);
	gameAbort->setText(i18n("Stop"));
	gamePause = new KAction(i18n("&Pause"), 0, tp, SLOT(pauseGame()), actionCollection(), "game_pausex");
	gamePause->setEnabled(false);

//  (void)new KAction( i18n("Show &Highscores..."), 0, this, SLOT( slotShowHighscores() ), actionCollection(), "game_hiscores" );
	KStdAction::quit(tp, SLOT(quitGame()), actionCollection(), "game_quit");

	KStdAction::preferences(this, SLOT( changePrefs() ), actionCollection());
	(void) new KAction(i18n("Select &Mission..."), 0, tp, SLOT(selectMission()), actionCollection(), "settings_mission");

	KStdAction::keyBindings(this, SLOT(configureKeys()), actionCollection());

#if KDE_VERSION < 310
	accel = new KAccel(this);

	accel->insertItem(i18n("Accelerate Upwards"), "Upx", Qt::Key_Up);
	accel->insertItem(i18n("Accelerate Leftwards"), "Left", Qt::Key_Left);
	accel->insertItem(i18n("Accelerate Downwards"), "Down", Qt::Key_Down);
	accel->insertItem(i18n("Accelerate Rightwards"), "Right", Qt::Key_Right);
	accel->insertItem(i18n("Toggle Flaps"), "Flaps", Qt::Key_F);

	gamePause->plugAccel(accel, true);

	accel->insertItem(i18n("Acknowledge Message"), "Acknowledge", Qt::Key_Space);

	accel->readSettings();
#else
	gameActions = new KActionCollection (this);

	(void) new KAction (i18n("Accelerate Upwards"), Qt::Key_Up, 0, 0, gameActions,  "Upx");
	(void) new KAction (i18n("Accelerate Leftwards"), KShortcut (Qt::Key_Left), 0, 0, gameActions,  "Left");
	(void) new KAction (i18n("Accelerate Downwards"), KShortcut (Qt::Key_Down), 0, 0, gameActions,  "Down");
	(void) new KAction (i18n("Accelerate Rightwards"), KShortcut (Qt::Key_Right), 0, 0, gameActions,  "Right");
	(void) new KAction (i18n("Toggle Flaps"), KShortcut (Qt::Key_F), this, SLOT (slotFlaps ()), gameActions,  "Flaps");
	(void) new KAction (i18n("Acknowledge Messages"), KShortcut (Qt::Key_Space), this, SLOT (slotAcknowledge ()), gameActions,  "Acknowledge");

	gameActions->readShortcutSettings ();
	actionCollection ()->readShortcutSettings ();
#endif

  	readKeys ();

	createGUI("taxipilotui.rc");
}

TaxipilotApp::~TaxipilotApp()
{
#if KDE_VERSION >= 310
	delete gameActions;
#endif
}

void TaxipilotApp::keyPressEvent(QKeyEvent * e)
{

#if KDE_VERSION < 310
	if (!actions.contains (e->key())) {
		e->ignore();
		return;
	}

	Action a = actions[e->key ()];

	switch (a) {
	case Left:
		tp->current_key_lr = -1;
		break;
	case Up:
		tp->current_key_ud = -1;
		break;
	case Right:
		tp->current_key_lr = 1;
		break;
	case Down:
		tp->current_key_ud = 1;
		break;
	case Acknowledge:
		tp->message_handler->acknowledged ();
		break;
	case Flaps:
		tp->toggle_flaps = true;
		break;
	default:{
			e->ignore();
		}
	}
#else
	KKey key(e);
	
	if (SUp.contains (key)) {
		tp->current_key_ud = -1;
	} else if (SDown.contains (key)) {
		tp->current_key_ud = 1;
	} else if (SLeft.contains (key)) {
		tp->current_key_lr = -1;
	} else if (SRight.contains (key)) {
		tp->current_key_lr = 1;
	} else {
		e->ignore ();
	}
#endif

}

/** We need this in combination with the above handler to work around slow auto-repeats:
	pressed keys are stored in (int) tp->current_key_lr (left is -1, right is 1), tp->current_key_ud (up is -1, down is 1),
	and tp->space_pressed (bool) until they get released. Current key is
	parsed by do_chores. */
void TaxipilotApp::keyReleaseEvent(QKeyEvent * e)
{
#if KDE_VERSION < 310
	if (!actions.contains (e->key())) {
		e->ignore();
		return;
	}

	Action a = actions[e->key ()];

	switch (a) {
	case Left:
		if (tp->current_key_lr == -1) {
			tp->current_key_lr = 0;
		}
		break;
	case Up:
		if (tp->current_key_ud == -1) {
			tp->current_key_ud = 0;
		}
		break;
	case Right:
		if (tp->current_key_lr == 1) {
			tp->current_key_lr = 0;
		}
		break;
	case Down:
		if (tp->current_key_ud == 1) {
			tp->current_key_ud = 0;
		}
		break;
	case Flaps:
		tp->toggle_flaps = false;
		break;
	default:{
			e->ignore();
		}
	}
#else
	KKey key(e);
	
	if (SUp.contains (key)) {
		if (tp->current_key_ud == -1) {
			tp->current_key_ud = 0;
		}
	} else if (SDown.contains (key)) {
		if (tp->current_key_ud == 1) {;
			tp->current_key_ud = 0;
		}
	} else if (SLeft.contains (key)) {
		if (tp->current_key_lr == -1) {
			tp->current_key_lr = 0;
		}
	} else if (SRight.contains (key)) {
		if (tp->current_key_lr == 1) {
			tp->current_key_lr = 0;
		}
	} else {
		e->ignore ();
	}
#endif
}

/** Calls up the key-Bindings-Dialog and sanity-checks
the settings */
void TaxipilotApp::configureKeys()
{

	bool ok;

	do {
		ok = true;
#if KDE_VERSION < 310
		KKeyDialog::configureKeys(accel, true, this);
		if ((!accel->currentKey("Upx")) || (!accel->currentKey("Down")) || (!accel->currentKey("Left"))
			|| (!accel->currentKey("Right")) || (!accel->currentKey("Acknowledge")) || (!accel->currentKey("Flaps"))) {
			ok = false;
			KMessageBox::sorry(this, i18n("The acceleration, flaps, and acknowledge-keys must be defined!"));
		}
#else
		KKeyDialog *dlg = new KKeyDialog (true);
		dlg->insert (actionCollection ());
		dlg->insert (gameActions);
		dlg->configure (true);
//		KKeyDialog::configure (actionCollection ());
		delete dlg;
		gameActions->writeShortcutSettings ();
		actionCollection ()->writeShortcutSettings ();
		if (gameActions->action ("Upx")->shortcut ().isNull () || gameActions->action ("Down")->shortcut ().isNull () ||
			gameActions->action ("Left")->shortcut ().isNull () || gameActions->action ("Right")->shortcut ().isNull () ||
			gameActions->action ("Acknowledge")->shortcut ().isNull () || gameActions->action ("Flaps")->shortcut ().isNull ()) {
			ok = false;
			KMessageBox::sorry(this, i18n("The acceleration, flaps, and acknowledge-keys must be defined!"));
		}
#endif
	} while (!ok);
	readKeys ();
}

/** No descriptions */
void TaxipilotApp::changePrefs(){
	Preferences *prefs = new Preferences ( tp );
	if ( prefs->exec() )
		// update everything
	delete prefs;
}

/** No descriptions */
bool TaxipilotApp::queryExit (){
	delete tp;
	return true;
}

/** Reads the Acclerator-keys into a QMap. Called at initialization and from configureKeys (). */
void TaxipilotApp::readKeys (){
#if KDE_VERSION < 310
	actions.clear ();

	actions.insert (accel->currentKey("Upx"), Up);
	actions.insert (accel->currentKey("Down"), Down);
	actions.insert (accel->currentKey("Left"), Left);
	actions.insert (accel->currentKey("Right"), Right);
	actions.insert (accel->currentKey("Flaps"), Flaps);
	actions.insert (accel->currentKey("Acknowledge"), Acknowledge);
	ack_key_name = KAccel::keyToString(accel->currentKey("Acknowledge"));

/*	actions.insert ((QKeySequence) (actionCollection ()->action ("Upx")->shortcut ()), Up);
	actions.insert (actionCollection ()->action ("Down")->shortcut ().keyCodeQt (), Down);
	actions.insert (actionCollection ()->action ("Left")->shortcut ().keyCodeQt (), Left);
	actions.insert (actionCollection ()->action ("Right")->shortcut ().keyCodeQt (), Right);
	actions.insert (actionCollection ()->action ("Flaps")->shortcut ().keyCodeQt (), Flaps);
	actions.insert (actionCollection ()->action ("Acknowledge")->shortcut ().keyCodeQt (), Acknowledge);
	ack_key_name = actionCollection ()->action ("Acknowledge")->shortcut ().toString (); */
#else
	SUp = gameActions->action ("Upx")->shortcut ();
	SDown = gameActions->action ("Down")->shortcut ();
	SLeft = gameActions->action ("Left")->shortcut ();
	SRight = gameActions->action ("Right")->shortcut ();
	ack_key_name = gameActions->action ("Acknowledge")->shortcut ().toString ();
#endif

}

/** This slot is in here and not in the Taxi-class, since the Taxi-class is not QObject-derived. */
void TaxipilotApp::slotFlaps(){
	tp->toggle_flaps = true;
}

/** This slot is in here and not in the Message-class, because the message-class is not QObject-derived. */
void TaxipilotApp::slotAcknowledge(){
	tp->message_handler->acknowledged ();
}
