/***************************************************************************
                          state.cpp  -  description
                             -------------------
    begin                : Thu Nov 22 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "defines.h"
#include "state.h"

#include <qstring.h>
#include <qdom.h>

#include "cdp.h"

State::State(const QDomElement *description, Cdp *cdpp){
	cdp = cdpp;
	read_state (description);
}

State::~State(){
}

/** Parses the description for this state */
void State::read_state (const QDomElement *description) {
	QString dummy = cdp->get_multi_choice_attribute ("initial", *description, "on;off", "off", 3);
	if (dummy == "on") {
		state = true;
	} else {
		state = false;
	}
	ident = cdp->get_string_attribute ("ident", *description, "a state", 1);	
}

/** Toggles the state */
void State::toggle (){
	state = !state;
/*	if (state) {
		cdp->debug_msg ( ident + ": on", 1, 0);
	} else {
		cdp->debug_msg ( ident + ": off", 1, 0);
	} */
}

/** Sets the state to new_state */
void State::set (bool new_state){
	state = new_state;
}

/** Returns, whether the state is currently set */
bool State::isSet (){
	return state;
}

/** Returns the identification string for this state */
QString State::get_ident (){
	return ident;
}
