/***************************************************************************
                          hotarea.cpp  -  description
                             -------------------
    begin                : Wed Feb 27 2002
    copyright            : (C) 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "defines.h"

#include "hotarea.h"

#include <qdom.h>
#include <qstring.h>
#include <qcanvas.h>

#include <klocale.h>

#include <level.h>
#include <event.h>
#include <cdp.h>

HotArea::HotArea(const QDomElement *description, Level *parent){
	level = parent;
	cdp = parent->cdp;
	read_area (description);
	touches = inside = false;
}

HotArea::~HotArea(){
	if (cdp->draw_highlight ()) {
		delete outline;
	}
}

/** Reads in the description for this area */
void HotArea::read_area (const QDomElement *description) {

	QString dummy;

	setCoords (cdp->get_int_attribute ("x1", *description, -10, 10000, 10, 1),
				cdp->get_int_attribute ("y1", *description, -10, 10000, 10, 1),
				cdp->get_int_attribute ("x2", *description, -10, 10000, 20, 1),
				cdp->get_int_attribute ("y2", *description, -10, 10000, 20, 1));

	if ((dummy = cdp->get_string_attribute ("touch_event", *description, "NOTHING", 3)) == "NOTHING") {
		has_touch_event = false;
	} else {
		touch_event = level->resolve_event (dummy);
        	has_touch_event = true;
	}
	if ((dummy = cdp->get_string_attribute ("untouch_event", *description, "NOTHING", 3)) == "NOTHING") {
		has_untouch_event = false;
	} else {
		untouch_event = level->resolve_event (dummy);
        	has_untouch_event = true;
	}
	if ((dummy = cdp->get_string_attribute ("enter_event", *description, "NOTHING", 3)) == "NOTHING") {
		has_enter_event = false;

	} else {
		enter_event = level->resolve_event (dummy);
        	has_enter_event = true;
	}
	if ((dummy = cdp->get_string_attribute ("leave_event", *description, "NOTHING", 3)) == "NOTHING") {
		has_leave_event = false;
	} else {
		leave_event = level->resolve_event (dummy);
        	has_leave_event = true;
	}

	if (!(has_touch_event || has_untouch_event || has_enter_event || has_leave_event)) {
		cdp->debug_msg (i18n ("No Events specified for this HotArea. It will not have any effect!"), 2, description);
	}

	if (cdp->draw_highlight ()) {
		outline = new QCanvasRectangle (*this, level->canvas ());
		outline->setPen(Qt::yellow);
		outline->setZ(LEVEL_Z + 1);
		outline->show();
	}
}

/** Checks, whether the taxi (given it's bounding rectangle) is in relevant relation to this area, and performs the
action applicable */
void HotArea::check (QRect taxirect) {

	if (has_touch_event || has_untouch_event) {
		if (intersects (taxirect) != touches) {
			touches = !touches;
			if (touches) {
				if (has_touch_event) {
					touch_event->trigger ();
				}
			} else {
				if (has_untouch_event) {
					untouch_event->trigger ();
				}
			}
		}
	}

	if (has_enter_event || has_leave_event) {
		if (contains (taxirect) != inside) {
			inside = !inside;
			if (inside) {
				if (has_enter_event) {
					enter_event->trigger ();
				}
			} else {
				if (has_leave_event) {
					leave_event->trigger ();
				}
			}
		}
	}
	
}
