/***************************************************************************
                          event.cpp  -  description
                             -------------------
    begin                : Fri Nov 23 2001
    copyright            : (C) 2001, 2002 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "defines.h"

#include "event.h"

#include <qdom.h>
#include <klocale.h>

#include "level.h"
#include "cdp.h"
#include "state.h"
#include "conditional.h"
#include "qstrlist.h"

Event::Event(const QDomElement *description, Level *parent) {
	level = parent;
	cdp = level->cdp;
	read_event (description);
	active = false;
}

Event::~Event(){
	if (num_changes) {delete [] changes;}
	if (has_conditional) {delete conditional;}
	if (num_child_events) {delete [] child_events;}
}

/** Reads in the description for this event */
void Event::read_event (const QDomElement *description){

	QDomNodeList list;
	QDomNode n;
	QDomElement e;

	ident = cdp->get_string_attribute ("ident", *description, "nothing", 0);

	list = cdp->get_node_list("change", *description, 0, -1, 1, 2);
	changes = new Changes [list.length()];
	num_changes = 0;
	if (list.length ()) {
		n = list.item(0);

		while (!n.isNull()) {		// get the list of states to be changed
			e = n.toElement();
	
			if (cdp->verify_tag ("change", e, 3)) {
				QString dummy = cdp->get_string_attribute ("state", e, "a state", 1);
			        changes[num_changes].state = level->resolve_state (dummy);
				dummy = cdp->get_multi_choice_attribute ("to", e, "toggle;on;off", "toggle", 1);
				if (dummy == "toggle") {
					changes[num_changes].change_type = 0;
				} else if (dummy == "on") {
					changes[num_changes].change_type = 1;
				} else {
					changes[num_changes].change_type = -1;
				}
				num_changes++;
	       	 	}

			n = n.nextSibling();
		}
	}

	list = cdp->get_node_list("child_event", *description, 0, -1, 1, 2);
	child_event_idents.clear ();
	num_child_events = 0;
	if (list.length()) {
		n = list.item(0);

		while (!n.isNull()) {		// get the list of child-events
			e = n.toElement();

			if (cdp->verify_tag ("child_event", e, 3)) {
				child_event_idents.append (cdp->get_string_attribute ("ident", e, "no event", 1));
				num_child_events++;
			}

			n = n.nextSibling();
		}
	}

	list = cdp->get_node_list("condition", *description, 0, 1, 1, 2);	// get conditional, if any
	if (list.length ()) {
		has_conditional = true;
		n = list.item(0);
		e = n.toElement ();
		conditional = new Conditional (&e, level);
 	} else {
		has_conditional = false;
	}

}

/** Triggers this event */
void Event::trigger(){
	if (active) {
		cdp->debug_msg (i18n ("Caught recursion in event '") + ident + i18n("'!"), 1, 0);
	} else {
		if (has_conditional) {
			if (!conditional->fulfilled ()) {
				return;
			}
		}
		active = true;
		int i;
		for (i=0; i < num_changes; i++) {
			if (!changes[i].change_type) {
				changes[i].state->toggle ();
			} else {
				changes[i].state->set (changes[i].change_type > 0);
			}
		}
		for (i=0; i < num_child_events; i++) {
			child_events[i]->trigger ();
		}
		active = false;
	}
}

/** Tells the event, that it can now resolve it's child events. Called by Level, when
all event-declarations have been read. */
void Event::resolve_now (){

	num_child_events = child_event_idents.count ();
	child_events = new Event * [num_child_events];
	
	for (int i = 0; i < num_child_events; i++) {
		QString dummy = child_event_idents.at(i);
		child_events[i] = level->resolve_event (dummy);
	}	
	
	child_event_idents.clear ();		// This list is no longer needed
}
