/***************************************************************************
                          teleporter.h  -  description
                             -------------------
    begin                : Tue Oct 30 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TELEPORTER_H
#define TELEPORTER_H


/**This class provides a generalized teleporter,
which may internally either be a static teleporter or a moving
object.
  *@author Thomas Friedrichsmeier
  */

#include <qstring.h>
#include <qrect.h>
#include <qobject.h>

class Level;
class Taxi;
class QDomElement;
class QCanvas;
class QCanvasSprite;
class MovingObject;
class Cdp;

class Teleporter:public QObject {
	Q_OBJECT
public:
	Teleporter(const QDomElement *description, Level *parent, QCanvas *canvas);
	~Teleporter();
/** Checks, whether the taxi would currently get teleported by this teleporter and if so,
teleports the taxi there, decreasing the score if appropriate.
Returns true, if teleportation took place */
	bool check_teleportation (Taxi *taxi, double *score);
/** The taxi is to be teleported to this teleporter */
	void teleport_to_you (Taxi *taxi, double f_x, double f_y);
/** Fulfills the promise (assigns the promised object to this teleporter) */
	void promise_fulfilled(MovingObject *obj);
/** Returns the current x-destination for teleporting to this teleporter */
	int destX ();
/** Returns the current y-destination for teleporting to this teleporter */
	int destY();
friend class Level;
private:
/** Whether this teleporter has been defined as an object, which will have to be connected */
	bool object_promised;
/** (redundant:) Whether the teleporter has a moving object */
	bool has_object;
/** The identification-string of the promised object */
	QString object_ident;

/** Whether the teleporter is currently visible (can not be active otherwise) */
	bool visible;
/** Whether the teleporter is currently active (not used yet) */
	bool active;

/** position (if static) */
	int x, y;
/** destination teleporter. You better make sure, it exists!
Like with the platforms, externally the teleporters are to be numbered starting with 1.
Set destination to 0, if you can't go anywhere from this teleporter. */
	int destination_tp;
/** Teleporting may have a price! */
	double fare;
/** These will be multiplied with your current speed. Could be very nasty */
	double factor_x, factor_y;
/** appearance of underlying moving object or constant sprite */
	QCanvasSprite *object;
/** this is the area that has to be covered by the taxi in order for the teleporter to become active */
	QRect hot_area;	
/** The offset of the hot_area to the top-left of the sprite (if not static) */
	int hot_area_off_x, hot_area_off_y;
/** The offset of the teleporter's center to the top left of the sprite (if not static) */
	int center_off_x, center_off_y;

/** Teleporter-sisters */
	Teleporter **sisters;
/** Pointer to the parent level */
	Level *level;
/** Whether the teleporter is currently blocked (because the taxi has not left it) */
	bool blocked;
/** The canvas */
	QCanvas *my_canvas;
/** The cdp */
	Cdp *cdp;
public slots: // Public slots
/** Tells the teleporter, whether it is currently
visible */
	void set_visible(bool visibility);
private: // Private methods
	/** Read the teleporter's description and creates the teleporter */
	void read_teleporter (const QDomElement *description);
	/** Calculates the (initial) hot_area for this teleporter */
	void calculate_hot_area ();
};

#endif
