/***************************************************************************
                          taxipilotapp.h  -  description
                             -------------------
    begin                : Sun Aug 12 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TAXIPILOTAPP_H
#define TAXIPILOTAPP_H

#include <qwidget.h>
#include <qmap.h>

#include <kmainwindow.h>
#include <kaction.h>
#include <kaccel.h>

#include "taxipilot.h"

/**
  *@author Thomas Friedrichsmeier
  */

/** All this class is currently responsible for is the creation of the menubar. All the actual work
is done by Taxipilot */
class TaxipilotApp:public KMainWindow {
  Q_OBJECT public:
	TaxipilotApp(QWidget * parent = 0, const char *name = 0);
	~TaxipilotApp();

	KAction *gameNew, *gamePause, *gameResume, *gameAbort;
  /** Taxipilot reads this */
	QString ack_key_name;
  private:
  /** Our beloved child */
	 Taxipilot * tp;

	enum Action { Up, Left, Down, Right, Acknowledge, Pause, Resume, Flaps };
	KAccel *accel;
	QMap < QString, Action > actions;

	bool flaps_key_pressed;

  protected:
  /** No descriptions */
	void keyPressEvent(QKeyEvent * e);
  /** We need this in combination with the above handler to work around slow auto-repeats:
	pressed keys are stored in (int) current_key, until they get released. Current-key is
	parsed by do_chores. Of course this only allows us one pressed key at a time, but that's
	just fine for now. */
	void keyReleaseEvent(QKeyEvent * e);
	private slots:				// Private slots
  /** Calls up the key-Bindings-Dialog and sanity-checks
the settings */
	void configureKeys();
public slots: // Public slots
  /** No descriptions */
  void changePrefs();
signals: // Signals
  /** No descriptions */
  void ack_key_pressed();
};

#endif
