/***************************************************************************
                          preferences.h  -  description
                             -------------------
    begin                : Tue Nov 27 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PREFERENCES_H
#define PREFERENCES_H

#include "preferences_gui.h"

/**This class derives from Preferences_gui, a QT-Designer-generated
Dialog, and adds all the life to it.
I don't know, whether this is the recommended procedure, but this way, I
can easily change the Dialog's appearance (or extend the dialog)
at a later point of time, without having to redo all the added code.
  *@author Thomas Friedrichsmeier
  */

class Taxipilot;
class Cdp;

class Preferences : public Preferences_gui  {
	Q_OBJECT
public:
	Preferences(Taxipilot *parent);
	~Preferences();
private:
	Cdp *cdp;
private slots: // Private slots
  /** Cancel-Button pressed. Exit */
  void cancel();
  /** Ok-Button pressed. Save changes */
  void ok();
  /** base_rate-slider changed. Update displays. */
  void base_rate_change(int new_val);
  /** fps-slider got changed. Update displays */
  void fps_change(int new_val);
  /** Select the default mission */
  void select_default_mission();
  /** Select the default mission path */
  void select_mission_path();
public slots: // Public slots
  /** No descriptions */
  void mission_selected();
};

#endif