/***************************************************************************
                          movingobject.h  -  description
                             -------------------
    begin                : Tue Oct 23 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MOVINGOBJECT_H
#define MOVINGOBJECT_H

#include <qcanvas.h>
#include <qobject.h>

class Taxipilot;
class QDomElement;
class Cdp;
class Level;
class QString;

/**
  *@author Thomas Friedrichsmeier
  */

class MovingObject : public QObject, public QCanvasSprite  {
	Q_OBJECT
public:
	MovingObject(const QDomElement *description, Taxipilot *parent, QCanvas *canvas);
	~MovingObject();
/** Whether the object would currently be harmful upon collision with the taxi */
	bool harmful ();
  /** Returns the current y-Velocity of the object */
  double current_vy();
  /** Returns the current x-velocity of the platform */
  double current_vx ();
friend class Level;
friend class Taxipilot;
private:
/** The pointer to the common debugging and prefixing class */
	Cdp *cdp;
/** Whether an identification string has been given to this object */
	bool has_ident;
/** The identification string itself */
	QString ident;

/** This struct holds all we need to know about where the object is going and what it looks like */
	struct PathSegment {
	/** A pointer to the anim to be used on this segment of the path */
		QCanvasPixmapArray *anim;
	/** This is the number of frames in the animation */
		int frames;
	/** The (predetermined) number of steps in this path-segment */
		int steps;
	/** The starting-point coordinates for this segment */
		double start_x, start_y;
	/** The starting speed on this segment */
		double vx, vy;
	/** The starting acceleration on this segment */
		double ax, ay;
	/** The change of acceleration on this segment (constant) */
		double dax, day;
	/** The timer-period (msecs; inverse of framerate) on this segment of the path (for the animation only) */
		int timer_period;			
	/** The z-Position in this segment of the path */
		double z;
	/** is the object visible on this segment? */
		bool visible;
	} *path;

/** The current frame in the current animation */
	int frame;
/** The current step in the current segment of the path */
	int step;
/** The current segment of the path */
	int current_segment;
/** The number of segments in the move-path */
	int segments;
/** is the object harmful when visible? */
	bool harmful_if_visible;
/** Whether the object is a teleporter */
	bool teleporter;
/** Whether the object is a center of gravity */
	bool center;
/** Whether the object is a platform */
	bool platform;
/** Whether the object has been visible on the last segment */
	bool last_visible;
/** Current velocity and acceleration of the object */
	double vx, vy, ax, ay;
	bool paused;
/** timer-ids */
	int advance_timer;
	int animation_timer;

private: // Private methods
/** This function reads a moving-object-description ( specs for the animations ) from a
QDomNode (of a level-description) read_object is only called by the constructor. */
	void read_object(const QDomElement *description);

protected:					// Protected methods
/** Advancing and animating */
	void timerEvent(QTimerEvent * e);

public slots: // Public slots
/** Resumes movement for a paused object */
	void resume();
/** Pauses the object */
	void pause();
signals: // Signals
/** Signals to whoever needs to know, whether the object
is currently visible or not, whenever it changes that state. */
	void am_visible(bool visible);
};

#endif
