/***************************************************************************
                          eqdial.cpp  -  description
                             -------------------
    begin                : Thu Oct 18 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "eqdial.h"

#include <qcolor.h>
#include <qpainter.h>

EQDial::EQDial(int min, int max, int step, int val, QWidget * parent, const char *name):QDial(min, max, step, val, parent,
	  name)
{
	check_upper = check_lower = false;
	normal.setRgb(0, 0, 0);
	warning.setRgb(250, 0, 0);
//	setEnabled (false);  // greys out the dial. not exactly what I want.
}

EQDial::~EQDial()
{
}

void EQDial::paintEvent(QPaintEvent * e)
{

	repaintScreen(&e->rect());

	paintWarning();
}

/** Sets the lower and upper warning limits. Negative values imply no limit set. */
void EQDial::setLimits(int lower, int upper)
{

	if (lower >= 0) {
		lower_limit = lower;
		check_lower = true;
	} else {
		check_lower = false;
	}

	if (upper >= 0) {
		upper_limit = upper;
		check_upper = true;
	} else {
		check_upper = false;
	}

}

/** No descriptions */
void EQDial::setColors(QColor & cnormal, QColor & cwarning)
{
	normal = cnormal;
	warning = cwarning;
}

/** Paints the warning LED */
void EQDial::paintWarning()
{
	QPainter p;

	p.begin(this);
	p.setPen(QColor(0, 0, 0));
	p.setBrush(normal);

	if (check_lower && (value() <= lower_limit)) {
		p.setBrush(warning);
	}
	if (check_upper && (value() >= upper_limit)) {
		p.setBrush(warning);
	}

	p.drawRect(width() / 2 - 5, height() - 15, 10, 10);
}

void EQDial::valueChange()
{
	repaintScreen();
	paintWarning();
}
