/***************************************************************************
                          conditional.cpp  -  description
                             -------------------
    begin                : Fri Nov 23 2001
    copyright            : (C) 2001 by Thomas Friedrichsmeier
    email                : Thomas.Friedrichsmeier@ruhr-uni-bochum.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "conditional.h"

#include <qdom.h>

#include "cdp.h"
#include "state.h"

Conditional::Conditional(const QDomElement *description, Cdp *cdpp){
	cdp = cdpp;
	read_conditional (description);
}

Conditional::~Conditional(){
	if (num_conditions) {delete [] conditions;}
}

/** Returns, whether the conditions are met */
bool Conditional::fulfilled (){
	for (int i = 0; i < num_conditions; i++) {
		if (conditions[i].state->isSet () != conditions[i].required) {
			return (false);
		}
	}
	return (true);
}

/** Reads in the configuration for this conditional */
void Conditional::read_conditional (const QDomElement *description){
}
