/*
 * Scenario.cpp - TaskJuggler
 *
 * Copyright (c) 2001, 2002, 2003, 2004 by Chris Schlaeger <cs@kde.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * $Id: Scenario.cpp 1218 2005-11-21 13:26:55Z cs $
 */

#include "Scenario.h"
#include "ScenarioList.h"
#include "Project.h"

Scenario::Scenario(Project* p, const QString& i, const QString& n,
                   Scenario* pr)
    : CoreAttributes(p, i, n, pr)
{
    p->addScenario(this);
    if (pr)
    {
        // Inherit settings from parent scenario.
        enabled = pr->enabled;
        projectionMode = pr->projectionMode;
        optimize = pr->optimize;
        strictBookings = pr->strictBookings;
    }
    else
    {
        enabled = true;
        projectionMode = false;
        optimize = false;
        strictBookings = false;
    }
}

Scenario::~Scenario()
{
    project->deleteScenario(this);
}

ScenarioListIterator
Scenario::getSubListIterator() const
{
    return ScenarioListIterator(*sub);
}

