#ifndef _NTFS_H
#define _NTFS_H


extern void
ntfs_dent_walk(FS_INFO *, INUM_T, int, FS_DENT_WALK_FN, char *);

extern void
uni2ascii(char *, int, char *, int);

extern u_int32_t
nt2unixtime(u_int64_t ntdate);

extern void
ntfs_attrname_lookup(FS_INFO *, u_int16_t, char *, int);

#define NTFS_FS_MAGIC	0x5346544E	/* "NTFS" in little endian */
#define NTFS_DEV_BSIZE	512		

#define NTFS_MAXNAMLEN	255

/* location of the Root Directory inode */
#define NTFS_ROOTINO	NTFS_MFT_ROOT	
#define NTFS_FIRSTINO	0	/* location of the $Mft Record */

#define NTFS_NDADDR			0
#define NTFS_NIADDR			0

typedef struct {
	u_int8_t	f1[3];	// 0
	char		magic[4];	// 3
	u_int8_t	f2[4];		// 7 
	u_int8_t	ssize[2];	// 11 	/* sector size in bytes */
	u_int8_t	csize;	 // 13	/* sectors per cluster */
	u_int8_t	f3[26]; // 14
	u_int8_t	vol_size_s[8]; 	// 40	/*size of volume in sectors */
	u_int8_t	mft_clust[8];	// 48 	/* location of MFT */
	u_int8_t	mftm_clust[8]; // 56	/* location of MFT mirror */
	int8_t		mft_rsize_c; // 64	/* number of clusters per mft record */
	int8_t		f4[3];
	int8_t		idx_rsize_c; // 68	/* number of clus per idx rec */
	int8_t		f5[3];
	u_int8_t	serial[8];	// 72	/* serial number */
	u_int8_t	f7[432]; //80
} ntfs_sb;

typedef struct {
	char		magic[4];
	u_int8_t	upd_off[2];			// 4
	u_int8_t	upd_cnt[2];			// 6  size+1
	u_int8_t	f1[8];				// 8
	u_int8_t	seq[2];				// 16
	u_int8_t	link[2];			// 18
	u_int8_t	attr_off[2];		// 20
	u_int8_t	flags[2];			// 22
	u_int8_t	size[4];			// 24
	u_int8_t	rec_size[4];		//28
	u_int8_t	file_ref[6];		// 32 
	u_int8_t	file_seq[2];		// 38 
	u_int8_t	max_attr[2];	// 40 max attr id + 1
	union {
		struct {
			u_int8_t	upd_val[2];	// 42
			u_int8_t	upd_seq;	// 44 array of size 2*(upd_cnt-1) w/orig vals
		} upd_30;
		struct {
			u_int8_t	f1[2];			// 42
			u_int8_t	mftnum[4];		// 44
			u_int8_t	upd_val[2];		// 48
			u_int8_t	upd_seq;		// 50 array of size 2*(upd_cnt-1) w/orig vals
		} upd_31;
	} upd;
} ntfs_mft;

#define NTFS_MFT_MAGIC	0x454c4946

/* flags for the flags value */
#define NTFS_MFT_INUSE	0x0001
#define NTFS_MFT_DIR	0x0002

/* flags for file_ref */
#define NTFS_MFT_BASE		0		/* set when the base file record */
/* Mask when not zero, which indicates the base file record */
#define NTFS_MFT_FILE_REC	0x00ffffffffffffff

/* DEFINED MFT entries */
#define NTFS_MFT_MFT	0x0
#define NTFS_MFT_MFTMIR	0x1
#define NTFS_MFT_LOG	0x2
#define NTFS_MFT_VOL	0x3
#define NTFS_MFT_ATTR	0x4
#define NTFS_MFT_ROOT	0x5
#define NTFS_MFT_BMAP	0x6
#define NTFS_MFT_BOOT	0x7
#define NTFS_MFT_BAD	0x8
#define NTFS_MFT_QUOT	0x9
#define NTFS_MFT_UPCASE	0xA



typedef struct {
	u_int8_t	type[4];
	u_int8_t	len[4];				// 4
	u_int8_t	res;				// 8
	u_int8_t	nlen;				// 9
	u_int8_t	cont_off[2];		// 10
	u_int8_t	compress[2];		// 12
	u_int8_t	id[2];				// 14

	union {		
		struct {
			u_int8_t	ssize[4];		// 16
			u_int8_t	soff[2];		// 20
			u_int8_t	idxflag[2];		// 22
			u_int8_t	name;
		} r;
		struct {
			u_int8_t	start_vcn[8];	// 16
			u_int8_t	last_vcn[8];	// 24
			u_int8_t	run_off[2];		// 32
			u_int8_t	f1[6];			// 34
			u_int8_t	alen[8];		// 40	allocated size of stream
			u_int8_t	ssize[8];		// 48	actual size of stream
			u_int8_t	compsize[8];	// 56   initialized steam size
			u_int8_t	name;
		} nr;
	} c;
} ntfs_attr;

/* values for the res field (resident or non-resident) */
#define NTFS_MFT_RES	0
#define NTFS_MFT_NONRES	1


/* values for the type field */
#define NTFS_ATYPE_SI       0x10    // 16
#define NTFS_ATYPE_ATTRLIST 0x20    // 32
#define NTFS_ATYPE_FNAME    0x30    // 48
#define NTFS_ATYPE_VVER     0x40    // 64 (NT)
#define NTFS_ATYPE_OBJID    0x40    // 64 (2K)
#define NTFS_ATYPE_SEC      0x50    // 80
#define NTFS_ATYPE_VNAME    0x60    // 96
#define NTFS_ATYPE_VINFO    0x70    // 112
#define NTFS_ATYPE_DATA     0x80    // 128
#define NTFS_ATYPE_IDXROOT  0x90    // 144 
#define NTFS_ATYPE_IDXALLOC 0xA0    // 160
#define NTFS_ATYPE_BITMAP   0xB0    // 176
#define NTFS_ATYPE_SYMLNK   0xC0    // 192 (NT)
#define NTFS_ATYPE_REPARSE  0xC0    // 192 (2K)
#define NTFS_ATYPE_EAINFO   0xD0    // 208
#define NTFS_ATYPE_EA       0xE0    // 224
#define NTFS_ATYPE_PROP     0xF0    //  (NT)
#define NTFS_ATYPE_LOG      0x100   //  (2K)


/*
 * File Name 
 */
typedef struct {
	u_int8_t	par_ref[6];	/* file reference to base File Record of parent */
	u_int8_t	par_seq[2];	/* seq num to base File Record of parent */
	u_int8_t	crtime[8];	/* file creation */
	u_int8_t	mtime[8];	/* file altered */
	u_int8_t	ctime[8];	/* mod time for FILE record */
	u_int8_t	atime[8];	/* access time */
	u_int8_t	alloc_fsize[8];
	u_int8_t	real_fsize[8];
	u_int8_t	flags[8];
	u_int8_t	nlen;			/* length of file name */
	u_int8_t	nspace;
	u_int8_t	name;		/* in unicode */
} ntfs_attr_fname;

/* values for the flags field of attr_fname */
#define	NTFS_FNAME_FLAGS_DIR	0x0000000010000000
#define	NTFS_FNAME_FLAGS_COMP	0x0000000000000800
#define	NTFS_FNAME_FLAGS_ARCH	0x0000000000000020
#define	NTFS_FNAME_FLAGS_SYS	0x0000000000000004
#define	NTFS_FNAME_FLAGS_HID	0x0000000000000002
#define	NTFS_FNAME_FLAGS_RO		0x0000000000000001

/* values for the name space values of nspace */
#define NTFS_FNAME_POSIX	0	/* case sensitive  and any but NULL and \ */
#define NTFS_FNAME_WIN32	1	// insensitive and restricted
#define NTFS_FNAME_DOS		2	// 8.3 format of 8-bit chars in uppercase
#define NTFS_FNAME_WINDOS	3	// name in WIN32 space that is already DOS


/* 
 * Standard Information 
 */
typedef struct {
	u_int8_t	crtime[8];	/* creation date */
	u_int8_t	mtime[8];	/* file altered */
	u_int8_t	ctime[8];	/* MFT Changed */
	u_int8_t	atime[8];	/* last access (read) */
	u_int8_t	dos[4];			/* permissions in DOS Format */
	u_int8_t	maxver[4];	
	u_int8_t	ver[4];	
	u_int8_t	class_id[4];
	u_int8_t	own_id[4];	
	u_int8_t	sec_id[4];	
	u_int8_t	quota[8];
	u_int8_t	usn[8];	
} ntfs_attr_si;

#define NTFS_SI_RO		0x0001
#define NTFS_SI_HID		0x0002
#define NTFS_SI_SYS		0x0004
#define NTFS_SI_ARCH	0x0020
#define NTFS_SI_DEV		0x0040
#define NTFS_SI_NORM	0x0080
#define NTFS_SI_TEMP	0x0100
#define NTFS_SI_SPAR	0x0200
#define NTFS_SI_REP		0x0400
#define NTFS_SI_COMP	0x0800
#define NTFS_SI_OFF		0x1000
#define NTFS_SI_NOIDX	0x2000
#define NTFS_SI_ENC		0x4000


/* 
 * Volume Info 
 */
typedef struct {
	u_int8_t	f1[8];
	u_int8_t	maj_ver;		
	u_int8_t	min_ver;		
	u_int8_t	flags[2];
	u_int8_t	f2[4];
} ntfs_attr_vinfo;

#define NTFS_VINFO_DIRTY	0x0001		// Dirty
#define NTFS_VINFO_RESLOG	0x0002		// Resize LogFile
#define NTFS_VINFO_UPGRAD	0x0004		// Upgrade on Mount
#define NTFS_VINFO_MNTNT4	0x0008		// Mounted on NT4
#define NTFS_VINFO_DELUSN	0x0010		// Delete USN Underway
#define NTFS_VINFO_REPOBJ	0x0020		// Repair Object Ids
#define NTFS_VINFO_MODCHK	0x8000		// Modified by chkdsk

/* versions 
 * NT = Maj=1 Min=2
 * 2k = Maj=3 Min=0
 * xp = Maj=3 Min=1
 */

#define NTFS_VINFO_NT		0x21
#define NTFS_VINFO_2K		0x03
#define NTFS_VINFO_XP		0x13

/* 
 * attribute list 
 */
typedef struct {
	u_int8_t	type[4];		// Attribute Type
	u_int8_t	len[2];			// length of entry
	u_int8_t	nlen;			// number of chars in name
	u_int8_t	f1;				// 7
	u_int8_t	start_vcn[8];	// starting VCN or NTFS_ATTRL_RES 
	u_int8_t	file_ref[6];	// file reference to new MFT entry
	u_int8_t	seq[2];			// 22
	u_int8_t	id[2];			// id (also in the attribute header)
	u_int8_t	name;			// 26  name in unicode
} ntfs_attrlist;

#define NTFS_ATTRL_RES	0


typedef struct {
	u_int8_t	len;	/* lsb 4 bits are size of len and 
						 *msb 4 are offset size*/
	u_int8_t	buf[32];
} ntfs_runlist;

#define NTFS_RUNL_LENSZ(runl)	\
	(runl->len & 0x0f)

#define NTFS_RUNL_OFFSZ(runl)	\
	((runl->len & 0xf0) >> 4)


/* Index root for directories 
 * the stream is a sequence of ntfs_idxentry structures
 *
 * The root node of the B+ tree is located in the stream
 */
typedef struct {
	u_int8_t	type[4];		/* ATYPE that tree is sorted by */
	u_int8_t	f1[4];
	u_int8_t	idx_size_b[4];	/* index buffer size in bytes */
	u_int8_t	idx_size_c;		/* index buffer size in clusters */
	u_int8_t	pad[3];
	u_int8_t	off_idxe[4];
	u_int8_t	strlen[4];		/* length of stream + 10 */
	u_int8_t	alloc[4];		/* allocated size of idx entries */
	u_int8_t	flags;	
	u_int8_t	pad2[3];	
	u_int8_t	stream;			/* sequence of index entries */
} ntfs_idxroot;

/* small means that there is no index alloc structure */
#define NTFS_IDX_SMALL	0x00
#define NTFS_IDX_LARGE	0x01


/* this is structure for the non-root nodes of the B+ directory tree
 * Starting at begin_off is a stream of ntfs_idxentry structures 
 */
typedef struct {
	u_int8_t	magic[4];	/* INDX */
	u_int8_t	upd_off[2];
	u_int8_t	upd_cnt[2];	/* size + 1 */
	u_int8_t	f1[8];
	u_int8_t	idx_vcn[8];	/* vcn in idx alloc attr */
	u_int8_t	begin_off[2];	/* offset to seq of idx entries -0x18 */
	u_int8_t	f2[2];
	u_int8_t	end_off[4];		/* offset to end of seq of idx entries -0x18 */
	u_int8_t	buf_off[4];		/* offset to end of idx buffer - 0x18 */
	u_int8_t	flags[4];		
	u_int8_t	upd_val[2];		/* sequence value  */
	u_int8_t	upd_seq;		/* 44 array of size 2*(upd_cnt-1) w/orig vals */
} ntfs_idxbuf;

#define NTFS_IDXBUF_MAGIC	0x58444e49   /* INDX */

/* value for flags */
#define NTFS_IDXBUF_NOTLEAF	0x1


/* This structure exists for each file and directory in the tree */
typedef struct {
	u_int8_t	file_ref[6]; /* file reference (when last entry) */
	u_int8_t	seq_num[2]; /* file reference (when last entry) */
	u_int8_t	idxlen[2];		/* length of index */
	u_int8_t	strlen[2];		/* length of stream */
	u_int8_t	flags;			
	u_int8_t	f1[3];
	u_int8_t	stream;			/* length of strlen */
} ntfs_idxentry;

#define NTFS_IDX_SUB	0x01	/* Entry points to a sub-node */
#define NTFS_IDX_LAST	0x02	/* last indx entry in the node */

/* return the address of the subnode entry, it is located in the last
 * 8 bytes of the structure 
 */
#define GET_IDXENTRY_SUB(e)	\
	(getu64((int)e + getu16(e->idxlen) - 8))


typedef struct {
	char		label[128];		/* label in unicode */
	u_int8_t	type[4];	
	u_int8_t	disp[4];	/* display rule */
	u_int8_t	coll[4];	/* collation rule */
	u_int8_t	flags[4];	
	u_int8_t	minsize[8];	/* minimum size */
	u_int8_t	maxsize[8];	/* maximum size */
} ntfs_attrdef;

#define NTFS_ATTRDEF_FLAGS_IDX	0x02
#define NTFS_ATTRDEF_FLAGS_RES	0x04	/* always resident */
#define NTFS_ATTRDEF_FLAGS_NONRES	0x08	/* allowed to be non-resident */

typedef struct {
	FS_INFO	fs_info;		/* super class */
	ntfs_sb	*fs;
	u_int8_t	ver;		/* version of NTFS - uses the VINFO flag */
	FS_INODE 	*mft_inode;	/* contains the data for the mft entry for the mft */
	FS_DATA 	*mft_data;	/* Data run for MFT entry for MFT */
	ntfs_mft	*mft;			/* cache for on-disk inode */	
	INUM_T	mnum;			/* number of above cached mft */
	u_int16_t	csize_b;	 /* number of bytes in a cluster */
	u_int16_t	ssize_b;	 /* number of bytes in a sector */
	u_int16_t	mft_rsize_b; /* number of bytes per mft record */
	u_int16_t	idx_rsize_b; /* number of bytes per idx record */
	DADDR_T		root_mft_addr;	/* address of first mft entry */
	
	FS_DATA_RUN *bmap;		/* Run of bitmap for clusters (linked list) */
	ntfs_attrdef *attrdef;

} NTFS_INFO;

#endif

