%define ver 0.9.0claws
%define rel 1
%define prefix /usr

Name: 		sylpheed
Version:	%{ver}
Release:	%{rel}
Source:		%{name}-%{ver}.tar.bz2
Copyright:	GPL
URL:		http://sylpheed-claws.sourceforge.net/
Summary:	a GTK+ based, lightweight, and fast e-mail client
Requires: 	gtk+ >= 1.2.6 gpgme
Group:		Productivity/Networking/Email/Clients
Packager:	Jens Oberender <j.obi@troja.net>
Buildroot:	/var/tmp/%{name}-root


%description
Sylpheed is an e-mail client (and news reader) based on GTK+, running on
X Window System, and aiming for
 * Quick response
 * Graceful, and sophisticated interface
 * Easy configuration, intuitive operation
 * Abundant features
The appearance and interface are similar to some popular e-mail clients for
Windows, such as Outlook Express, Becky!, and Datula. The interface is also
designed to emulate the mailers on Emacsen, and almost all commands are
accessible with the keyboard.

The messages are managed by MH format, and you'll be able to use it together
with another mailer based on MH format (like Mew). You can also utilize
fetchmail or/and procmail, and external programs on receiving (like inc or
imget).

Authors:
--------
    Hiroyuki Yamamoto <hiro-y@kcn.ne.jp>
    and others, have a look in AUTHORS

%prep
rm -rf $RPM_BUILD_ROOT

%setup

%build
%ifarch ppc64
export RPM_OPT_FLAGS="$RPM_OPT_FLAGS -mminimal-toc"
%endif
CFLAGS="$RPM_OPT_FLAGS" ./configure \
                --mandir=%{_mandir} \
                --prefix=%{prefix} \
                --infodir=%{_infodir} \
                --sysconfdir=%{_sysconfdir} \
                --enable-ldap \
                --enable-ipv6 \
                --enable-gpgme \
                --enable-openssl \
                --enable-jpilot \
                --enable-aspell
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && [ -d $RPM_BUILD_ROOT ] && rm -rf $RPM_BUILD_ROOT;
make DESTDIR=${RPM_BUILD_ROOT} install

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%{prefix}/bin/sylpheed
%{prefix}/share/locale/*/LC_MESSAGES/sylpheed.mo
%{prefix}/share/sylpheed/manual/*
%doc ABOUT-NLS AUTHORS COPYING ChangeLog ChangeLog.claws ChangeLog.jp README README.claws README.jp INSTALL TODO TODO.jp tools

%changelog
* Sun Nov 10 2002 Jens Oberender <j.obi@troja.net>
- changed spec.in for claws
- shortend the changelog

* Tue Jan 9 2001 Yoichi Imai <yoichi@silver-forest.com>
- edited for spec.in

* Tue Jan 2 2001 Hiroyuki Yamamoto <hiro-y@kcn.ne.jp>
- updated to 0.4.51
