/*
 * Sylpheed -- a GTK+ based, lightweight, and fast e-mail client
 * Copyright (C) 1999,2000 Hiroyuki Yamamoto
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __IMAP_H__
#define __IMAP_H__

#include <glib.h>

#include "folder.h"
#include "session.h"

typedef struct _IMAPSession	IMAPSession;

#include "prefs_account.h"

#define IMAP_SESSION(obj)	((IMAPSession *)obj)

struct _IMAPSession
{
	Session session;

	gchar *mbox;
};

#define IMAP_SUCCESS	0
#define IMAP_SOCKET	2
#define IMAP_AUTHFAIL	3
#define IMAP_PROTOCOL	4
#define IMAP_SYNTAX	5
#define IMAP_IOERR	6
#define IMAP_ERROR	7

#define IMAPBUFSIZE	8192


Session *imap_session_new		(const gchar	*server,
					 gushort	 port,
					 const gchar	*user,
					 const gchar	*pass);
void imap_session_destroy		(IMAPSession	*session);
void imap_session_destroy_all		(void);

GSList *imap_get_msg_list		(Folder		*folder,
					 FolderItem	*item,
					 gboolean	 use_cache);
gchar *imap_fetch_msg			(Folder		*folder,
					 FolderItem	*item,
					 gint		 num);

void imap_scan_folder			(Folder		*folder,
					 FolderItem	*item);

FolderItem *imap_create_folder		(Folder		*folder,
					 FolderItem	*parent,
					 const gchar	*name);

#endif /* __IMAP_H__ */
