/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2007 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Authors: Wez Furlong <wez@omniti.com>                                |
  |          Antony Dovgal <tony2001@php.net>                            |
  +----------------------------------------------------------------------+
*/

/* $Id: php_swish.h,v 1.2 2007/02/09 16:29:07 tony2001 Exp $ */

#ifndef PHP_SWISH_H
#define PHP_SWISH_H

extern zend_module_entry swish_module_entry;
#define phpext_swish_ptr &swish_module_entry

#ifdef PHP_WIN32
#define PHP_SWISH_API __declspec(dllexport)
#else
#define PHP_SWISH_API
#endif

#ifdef ZTS
#include "TSRM.h"
#endif

PHP_MINIT_FUNCTION(swish);
PHP_MSHUTDOWN_FUNCTION(swish);
PHP_RINIT_FUNCTION(swish);
PHP_RSHUTDOWN_FUNCTION(swish);
PHP_MINFO_FUNCTION(swish);

PHP_FUNCTION(confirm_swish_compiled);	/* For testing, remove later. */

/* 
  	Declare any global variables you may need between the BEGIN
	and END macros here:     

ZEND_BEGIN_MODULE_GLOBALS(swish)
	long  global_value;
	char *global_string;
ZEND_END_MODULE_GLOBALS(swish)
*/

/* In every utility function you add that needs to use variables 
   in php_swish_globals, call TSRMLS_FETCH(); after declaring other 
   variables used by that function, or better yet, pass in TSRMLS_CC
   after the last function argument and declare your utility function
   with TSRMLS_DC after the last declared argument.  Always refer to
   the globals in your function as SWISH_G(variable).  You are 
   encouraged to rename these macros something shorter, see
   examples in any other php module directory.
*/

#ifdef ZTS
#define SWISH_G(v) TSRMG(swish_globals_id, zend_swish_globals *, v)
#else
#define SWISH_G(v) (swish_globals.v)
#endif

#endif	/* PHP_SWISH_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
