/* -----------------------------------------------------------------------------
 * preprocessor.h
 *
 *     SWIG preprocessor module.
 *
 * Author(s) : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (C) 1999-2000.  The University of Chicago
 * See the file LICENSE for information on usage and redistribution.
 *
 * $Header: /cvs/projects/SWIG/Source/Preprocessor/preprocessor.h,v 1.5.4.2 2001/09/21 03:19:50 beazley Exp $
 * ----------------------------------------------------------------------------- */

#ifndef _PREPROCESSOR_H
#define _PREPROCESSOR_H

#include "swig.h"

#ifdef __cplusplus
extern "C" {
#endif

extern void  Preprocessor_expr_init(void);
extern int   Preprocessor_expr(DOHString *s, int *error);
extern char *Preprocessor_expr_error(void);
extern DOH  *Preprocessor_define(DOHString_or_char *str, int swigmacro);
extern void  Preprocessor_undef(DOHString_or_char *name);
extern void  Preprocessor_init();
extern DOH  *Preprocessor_parse(DOH *s);
extern void  Preprocessor_include_all(int);
extern void  Preprocessor_import_all(int);
extern int   Preprocessor_errors(void);

#ifdef __cplusplus
}
#endif

#endif




