
// Check a few of the INPUT, OUTPUT and INOUT typemaps.

import lib_typemaps.*;
import java.math.*;

public class lib_typemaps_runme {

  static {
    try {
	System.loadLibrary("lib_typemaps");
    } catch (UnsatisfiedLinkError e) {
      System.err.println("Native code library failed to load. See the chapter on Dynamic Linking Problems in the SWIG Java documentation for help.\n" + e);
      System.exit(1);
    }
  }

  public static void main(String argv[]) {

    // Check double INPUT typemaps
    if (lib_typemaps.in_double(22.22) != 22.22) exit_test("in_double");
    if (lib_typemaps.inr_double(22.22) != 22.22) exit_test("inr_double");

    // Check double OUTPUT typemaps
    {
        double[] var = {44.44};
        lib_typemaps.out_double(22.22, var);
        if (var[0] != 22.22) exit_test("out_double");
    }
    {
        double[] var = {44.44};
        lib_typemaps.outr_double(22.22, var);
        if (var[0] != 22.22) exit_test("outr_double");
    }

    // Check double INOUT typemaps
    {
        double[] var = {44.44};
        lib_typemaps.inout_double(var);
        if (var[0] != 44.44) exit_test("inout_double");
    }
    {
        double[] var = {44.44};
        lib_typemaps.inoutr_double(var);
        if (var[0] != 44.44) exit_test("inoutr_double");
    }


    // Check unsigned long long INPUT typemaps
    BigInteger forty = new BigInteger("40");
    BigInteger twenty = new BigInteger("20");
    if (!lib_typemaps.in_ulonglong(twenty).equals(twenty)) exit_test("in_ulonglong");
    if (!lib_typemaps.inr_ulonglong(twenty).equals(twenty)) exit_test("inr_ulonglong");

    // Check unsigned long long OUTPUT typemaps
    {
        BigInteger[] var = {new BigInteger("40")};
        lib_typemaps.out_ulonglong(twenty, var);
        if (!var[0].equals(twenty)) exit_test("out_ulonglong");
    }
    {
        BigInteger[] var = {new BigInteger("40")};
        lib_typemaps.outr_ulonglong(twenty, var);
        if (!var[0].equals(twenty)) exit_test("outr_ulonglong");
    }

    // Check unsigned long long INOUT typemaps
    {
        BigInteger[] var = {new BigInteger("40")};
        lib_typemaps.inout_ulonglong(var);
        if (!var[0].equals(forty)) exit_test("inout_ulonglong");
    }
    {
        BigInteger[] var = {new BigInteger("40")};
        lib_typemaps.inoutr_ulonglong(var);
        if (!var[0].equals(forty)) exit_test("inoutr_ulonglong");
    }
  }

  private static void exit_test(String funcName) {
      System.err.println("Test FAILED in function " + funcName);
      System.exit(1);
  }
}

