.\" @(#)swatch.8 1.0 92/04/02 Stanford University
.TH SWATCH 8 "13 December 1995"
.SH NAME
swatch \- simple watcher
.SH SYNOPSIS
.B swatch
.RB [ " \-c "
.IR config_file " ]"
.RB [ " \-r "
.IR restart_time " ]"
.RB [ " \-P "
.IR pattern_separator " ]"
.RB [ " \-A "
.IR action_separator " ]"
.RB [ " \-I "
.IR input_record_separator " ]"
.RB [ [ " \-f "
.IR file_to_examine " ] | [ "
.B \-p
.IR program_to_pipe_from " ] | [ "
.B \-t
.IR file_to_tail " ]] "
.SH DESCRIPTION
.B Swatch
is designed to monitor system activity.
.B Swatch
requires a configuration file which contains
.I pattern(s)
to look for and
.I action(s)
to do when each pattern is found.
.SH OPTIONS
.TP 15
.BI \-c " filename"
Use
.I filename
as the configuration file.
.TP
.BI \-r " restart_time"
Automatically restart at specified time.
.I Time
can be in any of the following formats:
.RS 5
.TP
.B +hh:mm
Restart after the specified time where
.I hh
is hours and
.I mm
is minutes.
.TP
.B hh:mm[am|pm]
Restart at the specified time.
.RS -5
.TP
.BI \-P " pattern_separator"
Tells
.B swatch(8)
to use
.I pattern_separator
when parsing the patterns in the configuration file.
The default is a comma.
.TP
.BI \-A " action_separator"
Tells
.B swatch(8)
to use
.I action_separator
when parsing the actions in the configuration file.
The default is a comma.
.TP
.BI \-I " input_record_separator"
Tells
.B swatch(8)
to use
.I input_record_separator
as the character(s) which mark the boundary of each input record.
The default is a carriage return.
.PP
You may specify only one of the following options:
.TP 20
.BI -f " filename"
Use
.I filename
as the file to examine.
.B Swatch
will do a single pass through the named file.
.TP
.BI -p " program_name"
Examine input piped in from the
.IR program_name "."
.TP
.BI -t " filename"
Examine lines of text as they are added to
.IR filename "."
.PP
If swatch is called with no options, it is the same as typing the 
command line
.IP
swatch -c ~/.swatchrc -t /var/log/syslog
.SH SEE ALSO
.BR swatch (5),
.BR signal (3)
.SH AUTHOR
.nf
.IR "E. Todd Atkins" " (Todd.Atkins@CAST.Stanford.EDU)"
Computer Administration Support Team
Distributed Computing Group
Stanford University
.fi
.IP
.SH NOTES
Upon receiving a ALRM or HUP signal swatch will re-read the
configuration file and restart.
Swatch will terminate gracefully
when it receives a QUIT, TERM, or INT signal.
