# $Id: sw_history.pl,v 2.0 1994/03/25 19:32:45 atkins Exp atkins $
#
# Created on Thu May 13 14:33:49 PDT 1993 by Todd_Atkins@CAST.Stanford.EDU
#
#
# Copyright (1995) The Board of Trustees of the Leland Stanford Junior
# Univeristy.  Except for commercial resale, lease, license or other commercial
# transactions, permission is hereby given to use, copy, modify, and distribute
# this software -- by exercising this permission you agree that this Notice
# shall accompany this software at all times. 
# 
# STANFORD MAKES NO REPRESENTATIONS OR WARRANTIES OF ANY KIND CONCERNING
# THIS SOFTWARE.

#
# $Log: sw_history.pl,v $
# Revision 2.0  1994/03/25  19:32:45  atkins
# 2.0 revision with RCS Id and Log added
#
#
$ENV{'PATH'} = '/usr/ucb:/usr/bin:/bin:/eecf/bin';
$ENV{'IFS'} = '' if $ENV{'IFS'} ne '';

##
## strip_message -- cut out an unwanted section of the message
##
## inputs:	$message -- the message to splice
##		$cut_marks -- information on where to cut in the form
##			starting_position:length_of_cut
##
## returns:	a string containing the spliced message
##
## side effects: sets $OriginalMsg the message before it got cut up
##
sub strip_message {
    local($message,$cut_marks) = @_;
    local($pos,$len) = split(/:/,$cut_marks);
    $OriginalMsg = $message;
    substr($message,$pos,$len) = '';
    return($message);
}

##
## skip_message -- determines the disposition of a message by looking at its 
##	history
##
## inputs:	$message -- the message in question
##		$min_time -- minimum accepted time between messages (in seconds)
##
## returns:	0 -- if the message arrived after $time of the last alike 
##			message.
##		1 -- if not.
##
## side effects:
##		$MessageCount -- sets to the number of alike messages since the 
##			first alike message of the interval.
##		$MessageInterval -- sets to the real length of the interval
##			because it may be greater than $time.
##		Entries for the $message in the following arrays are reset
##		if we are returning 0 or updated if we are returning 1.
##		  %MessageCount -- number of alike messages
##		  %MessageTimeOfFirst -- time in which the %MessageCount
##			entry was zero.
##		
##
sub skip_message {
    local($message,$min_time) = @_;
    local($now_time) = time;
  
    if (defined $MessageTimeOfFirst{$message}) {
        if ( ($now_time - $MessageTimeOfFirst{$message}) > $min_time ) {
            ## set these for external use ##
            $MessageCount = $MessageCount{$message} + 1;
            $MessageInterval = $now_time - $MessageTimeOfFirst{$message};

            ## reset the entry ##
            $MessageCount{$message} = 0;
            $MessageTimeOfFirst{$message} = $now_time;

            return 0;
        } else {
            ## Increment the count for the entry ##
            $MessageCount{$message}++;
            return 1;
        }
    } else {
        ## create a new entry ##
        $MessageTimeOfFirst{$message} = $now_time;
        $MessageCount{$message} = 1;
        return 0;
    }
}

##
## format_message -- prepend the history info to the message
##
## input: 	$message -- the original message
##		$cut_marks -- time stamp marker
##		$exact -- true/false flag for exact matching
##
## uses:
##		$MessageCount -- no. of alike messages during interval
##		$MessageInterval -- The time of the interval in seconds
##
## returns:	a formatted string with history information prepended to
##		the message.
##
sub format_message {
    local($message,$cut_marks,$exact) = @_;
    local($new_msg,$time);

    local($BoldPrint)           =  "\033[1m" ;
    local($BlinkPrint)          =  "\033[5m" ;
    local($InversePrint)        =  "\033[7m" ;
    local($NormalPrint)         =  "\033[0m" ;
    local($UnderscorePrint)     =  "\033[4m" ;

    if (!defined $MessageCount) { # return original message
        return $message;
    } else {
	$time = &readable_time($MessageInterval);

	if ($exact == 1) {
            $new_msg .= "\033[1m\033[5m**\033[0m $MessageCount seen in $time \033[5m==>\033[0m $message";
	} else {
            $new_msg .= "\033[1m\033[5m**\033[0m $MessageCount seen in $time \033[5m-->\033[0m $message";
	}

        undef $MessageCount;
        return $new_msg;
    }
}


##
## time_with_words -- converts seconds to a string which says
##	how many hours, minutes, and seconds it is.
##
sub time_with_words {
    local($seconds) = @_;
    local($hours,$minutes);
    $hours = $seconds / (60*60);
    $seconds %= (60*60);
    $minutes = $seconds / 60;
    $seconds %= 60;

    $hours =~ s/\s+//g;
    $minutes =~ s/\s+//g;
    $seconds =~ s/\s+//g;

    local($rtn);
    $rtn = sprintf(" %d hours", $hours) if $hours > 1;
    $rtn .= sprintf(" %d hour", $hours) if $hours == 1;
    $rtn .= sprintf(" %d minutes", $minutes) if $minutes > 1;
    $rtn .= sprintf(" %d minute", $minutes) if $minutes == 1;
    $rtn .= sprintf(" %d seconds", $seconds) if $seconds > 1;
    $rtn .= sprintf(" %d second", $seconds) if $seconds == 1;

    return $rtn;
}

##
## readable_time -- converts seconds to a string which says
##	how many hours, minutes, and seconds it is.
##
sub readable_time {
    local($seconds) = @_;
    local($hours,$minutes);
    $hours = $seconds / (60*60);
    $seconds %= (60*60);
    $minutes = $seconds / 60;
    $seconds %= 60;

    return sprintf("%2.2d:%2.2d:%2.2d", $hours, $minutes, $seconds);

#    $hours =~ s/\s+//g;
#    $minutes =~ s/\s+//g;
#    $seconds =~ s/\s+//g;

#    local($rtn);
#    $rtn = sprintf(" %d hours", $hours) if $hours > 1;
#    $rtn .= sprintf(" %d hour", $hours) if $hours == 1;
#    $rtn .= sprintf(" %d minutes", $minutes) if $minutes > 1;
#    $rtn .= sprintf(" %d minute", $minutes) if $minutes == 1;
#    $rtn .= sprintf(" %d seconds", $seconds) if $seconds > 1;
#    $rtn .= sprintf(" %d second", $seconds) if $seconds == 1;

#    return $rtn;
}
1;
