/*	$Id: sudoku-handler.c,v 1.2 2007/05/26 00:38:57 mbalmer Exp $ */

/*
 * Copyright (c) 2007 Marc Balmer <marc@msys.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>

#include <ctype.h>
#include <err.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>

#include <ClearSilver.h>
#include <fcgi_stdio.h> 

#include "sudoku.h"

int verbose = 0;
volatile sig_atomic_t	quit = 0;

#define PATH_SOCK "/var/www/fastcgi/sudoku.sock"
#define INPUT_TMPL "/usr/local/share/sudoku/input.cs"
#define OUTPUT_TMPL "/usr/local/share/sudoku/output.cs"
#define TABLE_TMPL "/usr/local/share/sudoku/table.cs"

void
sighdlr(int signum)
{
	switch (signum) {
	case SIGINT:
	case SIGTERM:
		quit = 1;
	}
}

int
fcgi_cs_read(void *rock, char *buf, int len)
{
	return FCGI_fread(buf, sizeof(char), len, FCGI_stdin);
}

int
fcgi_cs_writef(void *rock, const char *fmt, va_list ap)
{
	return FCGI_vprintf(fmt, ap);
}

int
fcgi_cs_write(void *rock, const char *buf, int len)
{
	return FCGI_fwrite((char *)buf, sizeof(char), len, FCGI_stdout);
}

int
solve_handler(CGI *cgi, HDF *hdf)
{
	char f[10][9][9];
	char r[10][9][9];
	char name[32], fnam[8];
	char out[2];
	char *val;
	int x, y, n, value;

	bzero(f, sizeof(f));
	for (n = 0, y = 0; y < 9; y++) {
		for (x = 0; x < 9; x++) {
			snprintf(name, sizeof(name), "Query.f%d", n);
			val = hdf_get_value(hdf, name, NULL);
			if (val != NULL) {
				value = atoi(val);
				if (value > 0 && value < 10 &&
				    set(f, x, y, value)) {
					syslog(LOG_INFO, "input error, "
					    "%d at %d,%d", value, x, y);
				}
			}
			n++;
		}
	}
	bcopy(f, r, sizeof(r));
	while (find(r))
		;
	if (!complete(r)) {
		hdf_set_value(hdf, "guessed", "true");
		guess(r);
	}
	out[1] = '\0';
	for (n = 0, y = 0; y < 9; y++) {
		for (x = 0; x < 9; x++) {
			out[0] = '\0';
			snprintf(name, sizeof(name),
			    "row.%d.column.%d.value", y, x);
			if (r[0][x][y])
				out[0] = '0' + r[0][x][y];
			hdf_set_value(hdf, name, out);
			snprintf(name, sizeof(name),
			    "row.%d.column.%d.name", y, x);
			snprintf(fnam, sizeof(fnam), "f%d", n);
			hdf_set_value(hdf, name, fnam);
			if (f[0][x][y]) {
				snprintf(name, sizeof(name),
				    "row.%d.column.%d.preset", y, x);
				hdf_set_value(hdf, name, "true");
			}
			n++;
		}
	}
	if (complete(r))
		cgi_display(cgi, TABLE_TMPL);
	else
		cgi_display(cgi, OUTPUT_TMPL);
	return 0;
}

int
fcgi_handler()
{
	CGI *cgi;
	HDF *hdf;
	char *act;
	int retval = 0;

	hdf_init(&hdf);
	cgi_init(&cgi, hdf);
	cgi_parse(cgi);

#ifdef DEBUG
	hdf_set_value(hdf, "debug", "on");
#endif

	act = hdf_get_value(hdf, "Query.op", "");

	if (!strcmp(act, "solve"))
		retval = solve_handler(cgi, hdf);
#ifdef DEBUG
	else if (!strcmp(act, "restart")) {	/* XXX test only! */
		retval = -2;
		cgi_display(cgi, INPUT_TMPL);
	} else if (!strcmp(act, "quit")) {	/* XXX test only! */
		quit = 1;
		cgi_display(cgi, INPUT_TMPL);
	}
#endif
	else
		cgi_display(cgi, INPUT_TMPL);

	cgi_destroy(&cgi);
	return retval;
}

int
main(int argc, char *argv[], char *envp[])
{
	struct sockaddr_un servaddr;
	int s, retval = 0;

	daemon(1, 0); 	/* nochdir, close */

	cgiwrap_init_std(argc, argv, envp);
	cgiwrap_init_emu(NULL, fcgi_cs_read, fcgi_cs_writef, fcgi_cs_write,
	    NULL, NULL, NULL);

	s = socket(AF_UNIX, SOCK_STREAM, 0);
	bzero(&servaddr, sizeof(servaddr));
	servaddr.sun_family = AF_UNIX;
	strlcpy(servaddr.sun_path, PATH_SOCK, sizeof(servaddr.sun_path));
	if (bind(s, (struct sockaddr *)&servaddr, sizeof(servaddr)))
		err(1, "bind failed");
	syslog(LOG_INFO, "bound to socket\n");
	chmod(PATH_SOCK, S_IRUSR | S_IWUSR | S_IRGRP |
	    S_IWGRP);
	if (listen(s, 4))
		err(1, "listen failed");
	syslog(LOG_INFO, "listening\n");

	dup2(s, 0);

	signal(SIGTERM, sighdlr);
	signal(SIGINT, sighdlr);

	syslog(LOG_INFO, "Ready to process fast cgi queries");
	while (!quit && retval != -2 && FCGI_Accept() >= 0) {
		syslog(LOG_INFO, "processing request");
		retval = fcgi_handler();
		FCGI_Finish();
	}

	syslog(LOG_INFO, "terminating");
	unlink(PATH_SOCK);
	
	if (retval == -2)	/* XXX restart hack */
		if (fork() == 0)
			execve(argv[0], argv, envp);

	return 0;
}
