/*
 * This file is part of sudognu.
 *
 * Copyright (C) 2007 Jens Baaran, Germany.
 ******************************************************************************/

//#include <stdio.h>
//#include <ctype.h>
#include <string.h>
//#include <stdlib.h>
#include "sudoku.h"

//#undef DEBUG
//#define DEBUG 1

/*
 ******************************************************************************/
int xy_wing(t_sudoku *sudoku, int doElim, int verbosity) {
	
	int r, c, cc, x, y, z, a, b, i, nwing = 0, nelim = 0, nb, nbp1, nbp2, ncn;
	int neighb[NUM_NEIGHBOURS][2];
	int comNeighb[NUM_NEIGHBOURS][2];
	int size = sudoku->size;
	t_field fld;
	char estr[512];
	
	for (r = 0; r < size; r++) {
		for (c = 0; c < size; c++) {
			// for all possible pivots (cells with 2 candidates: x,y)
			nbp1 = nbp2 = -1;
			if (sudoku->grid[r][c].ncand == 2) {
				cc = x = y = 0;
				while (x == 0) x = sudoku->grid[r][c].cand[cc++];
				while (y == 0) y = sudoku->grid[r][c].cand[cc++];
				get_neighbours(r, c, neighb);
				
				// Look for pincer 1 in cells that see the pivot. Pincer 1 has 2
				// candidates x, z.
				for (nb = 0; nb < NUM_NEIGHBOURS; nb++) {
					fld = sudoku->grid[neighb[nb][0]][neighb[nb][1]];
					if (fld.ncand == 2) {
						cc = a = b = z = 0;
						while (a == 0) a = fld.cand[cc++];
						while (b == 0) b = fld.cand[cc++];
						if ((a == x) && (b != y)) {
							z = b;
							nbp1 = nb;
						}
						else if ((a != x) && (b == y)) {
							z = a;
							y = x;
							x = b;
							nbp1 = nb;
						}
					}
					if (nbp1 >= 0) {

						// Look for pincer 2 in cells that see the pivot. Pincer 2 has 2
						// candidates y, z.
						for (nb = 0; nb < NUM_NEIGHBOURS; nb++) {
							fld = sudoku->grid[neighb[nb][0]][neighb[nb][1]];
							if (fld.ncand == 2) {
								cc = a = b = 0;
								while (a == 0) a = fld.cand[cc++];
								while (b == 0) b = fld.cand[cc++];
								if (((a == y) && (b == z)) || ((a == z) && (b == y))) {
									nbp2 = nb;
								}
							}
							if (nbp2 >= 0) {
								// Look for candidate z in cells that see both pincers. These
								// candidates can be eliminated.
								// both pincers may not be within same block, same row or same column
								ncn = get_common_neighbours(neighb[nbp1],neighb[nbp2],comNeighb);
								if (ncn <= SIZE2-SIZE) {
									i = nelim = 0;
									while(comNeighb[i][0] != -1) {
										if (sudoku->grid[comNeighb[i][0]][comNeighb[i][1]].cand[z-1] != 0) {
											if (doElim == 1) {
												if (DEBUG) {
													fprintf(stderr,"pivot at r%dc%d, candidates (%d,%d)\n",r+1,c+1,x,y);
													fprintf(stderr,"pincer 1 at r%dc%d, candidates (%d,%d)\n",neighb[nbp1][0]+1,neighb[nbp1][1]+1,x,z);
													fprintf(stderr,"pincer 2 at r%dc%d, candidates (%d,%d)\n",neighb[nbp2][0]+1,neighb[nbp2][1]+1,y,z);
													fprintf(stderr,"%d common neighbours\n",ncn);
													fprintf(stderr,"found xy-wing!!!\n eliminate candidate %d from r%dc%d\n",z,comNeighb[i][0]+1,comNeighb[i][1]+1);
													fflush(stderr);
													print_candidates_as_grid(*sudoku);
													fflush(stdout);
												}
												sudoku->grid[comNeighb[i][0]][comNeighb[i][1]].cand[z-1] = 0;
												sudoku->grid[comNeighb[i][0]][comNeighb[i][1]].ncand--;
											}
											nelim++;
										}
										i++;
									}
									if (nelim > 0) {
										nwing++;
										if (doElim == 1) goto done;
									}
								}
							}
							// continue looking for 1st pincer, unset nbp1
						}
						// unset nbp1
						nbp1 = -1;
					}
					// continue looking for 1st pincer
				}
			}
			// continue looking for pivot
		}
	}
	
	done:
	if ((doElim == 1) && (nelim > 0)) {
		sprintf(estr,"W  r%dc%d r%dc%d r%dc%d",r+1,c+1,neighb[nbp1][0]+1,neighb[nbp1][1]+1,neighb[nbp2][0]+1,neighb[nbp2][1]+1);
		sprintf(estr+strlen(estr),", (%d %d %d) xy-wing, -%d candidates %d",x,y,z,nelim,z);
		fprint_explain(estr,*sudoku,verbosity);
	}
	
	return(nwing);
}

/*
 ******************************************************************************/
int xyz_wing(t_sudoku *sudoku, int doElim, int verbosity) {
	
	int pivot[2], cc, x, y, z, i, nwing = 0, nelim = 0, nb, nbp1, nbp2, ncc, k, tmp;
	int neighb[NUM_NEIGHBOURS][2];
	int comNeighb[NUM_NEIGHBOURS][2];
	int size = sudoku->size;
	char estr[512];
	t_field fld;
	
	for (pivot[0] = 0; pivot[0] < size; pivot[0]++) {
		for (pivot[1] = 0; pivot[1] < size; pivot[1]++) {
			// for all possible pivots (cells with 3 candidates: x,y,z)
			if (sudoku->grid[pivot[0]][pivot[1]].ncand == 3) {
				cc = x = y = z = 0;
				while (x == 0) x = sudoku->grid[pivot[0]][pivot[1]].cand[cc++];
				while (y == 0) y = sudoku->grid[pivot[0]][pivot[1]].cand[cc++];
				while (z == 0) z = sudoku->grid[pivot[0]][pivot[1]].cand[cc++];
				get_neighbours(pivot[0], pivot[1], neighb);

				// test all combinations of x y z, 1st try to eliminate z, then x, then y
				for (k=0; k<3; k++) {
					nbp1 = nbp2 = -1;
				
					// Look for pincer 1 in cells that see the pivot. Pincer 1 has 2
					// candidates x, z.
					for (nb = 0; nb < NUM_NEIGHBOURS; nb++) {
						fld = sudoku->grid[neighb[nb][0]][neighb[nb][1]];
						if ((fld.ncand == 2) && (fld.cand[x-1] != 0) && (fld.cand[z-1] != 0)) {
							nbp1 = nb;
						}
						// Look for pincer 2 in cells that see the pivot. Pincer 2 has 2
						// candidates y, z.
						if (nbp1 >= 0) {
							for (nb = 0; nb < NUM_NEIGHBOURS; nb++) {
								fld = sudoku->grid[neighb[nb][0]][neighb[nb][1]];
								if ((fld.ncand == 2) && (fld.cand[y-1] != 0) && (fld.cand[z-1] != 0)) {
									nbp2 = nb;
								}
								if (nbp2 >= 0) {
									// Look for candidate z in cells that see both pincers and
									// the pivot. These candidates can be eliminated. both
									// pincers may not be within same block, same row or same
									// column
									ncc = get_common_neighbours3(pivot,neighb[nbp1],neighb[nbp2],comNeighb);
									// if ncc > SIZE-1, pivot and pincers are located within same
									// row, block, or column --> no xyz wing
									if ((ncc > 0) && (ncc < SIZE)) {
										i = nelim = 0;
										while(comNeighb[i][0] != -1) {
											if (sudoku->grid[comNeighb[i][0]][comNeighb[i][1]].cand[z-1] != 0) {
												if (doElim == 1) {
													if (DEBUG) {
														fprintf(stderr,"pivot at r%dc%d, candidates (%d,%d,%d)\n",pivot[0]+1,pivot[1]+1,x,y,z);
														fprintf(stderr,"pincer 1 at r%dc%d, candidates (%d,%d)\n",neighb[nbp1][0]+1,neighb[nbp1][1]+1,x,z);
														fprintf(stderr,"pincer 2 at r%dc%d, candidates (%d,%d)\n",neighb[nbp2][0]+1,neighb[nbp2][1]+1,y,z);
														fprintf(stderr,"found xyz-wing!!!\n eliminate candidate %d from r%dc%d\n",z,comNeighb[i][0]+1,comNeighb[i][1]+1);
														fflush(stderr);
														print_candidates_as_grid(*sudoku);
														fflush(stdout);
													}
													sudoku->grid[comNeighb[i][0]][comNeighb[i][1]].cand[z-1] = 0;
													sudoku->grid[comNeighb[i][0]][comNeighb[i][1]].ncand--;
												}
												nelim++;
											}
											i++;
										}
										// count wings & return, if candidate was eliminated
										if (nelim > 0) {
											nwing++;
											if (doElim == 1) goto done;
										}
									}
								}
								// continue looking for 2nd pincer
							}
							// done looking for 2nd pincer, unset 1st pincer
							nbp1 = -1;
						}
						// continue looking for 1st pincer
					}
					// now try to eliminate x, x->y, y->z, z->x
					tmp = x;
					x = y;
					y = z;
					z = tmp;
				}
			}
			// continue looking for pivot
		}
	}
	
	done:
	if ((doElim == 1) && (nelim > 0)) {
		sprintf(estr,"Y  r%dc%d r%dc%d r%dc%d",pivot[0]+1,pivot[1]+1,neighb[nbp1][0]+1,neighb[nbp1][1]+1,neighb[nbp2][0]+1,neighb[nbp2][1]+1);
		sprintf(estr+strlen(estr),", (%d %d %d) xyz-wing, -%d candidates %d",x,y,z,nelim,z);
		fprint_explain(estr,*sudoku,verbosity);
	}

	return(nwing);
}
