#ifndef _debug_h
#define _debug_h

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <glib.h>

enum SE_DEBUG_MESSAGE_FLAG
{
	SE_NO_DEBUG							= 0,

	SE_DEBUG_APP						= 1 << 0,
	SE_DEBUG_VIEW						= 1 << 1,
	SE_DEBUG_LOADER					= 1 << 2,
	SE_DEBUG_SAVER					= 1 << 3,
	SE_DEBUG_SEARCH					= 1 << 4,
	SE_DEBUG_REGEX					=	1	<< 5,
	SE_DEBUG_GSTREAMER			= 1 << 6,
	SE_DEBUG_SPELL_CHECKING	= 1 << 7,

	SE_DEBUG_ALL			=	1 << 9
};



/*
 *
 */
void se_debug_init(int argc, char *argv[]);

/*
 *
 */
void __se_debug( int flag, 
		const gchar* file, 
		gint line, 
		const gchar* fonction);

/*
 *
 */
void __se_debug_message( int flag, 
		const gchar* file, 
		gint line, 
		const gchar* fonction, 
		const char *string, ...);


#ifdef DEBUG

	/*
	 *
	 */
	#define se_debug(flag) __se_debug(flag, __FILE__, __LINE__, __FUNCTION__);

	/*
	 *
	 */
	#define se_debug_message(flag, ...) __se_debug_message(flag, __FILE__, __LINE__, __FUNCTION__, __VA_ARGS__);

#else//DEBUG
	#define se_debug(flag)
	#define se_debug_message(flag, ...)
#endif//DEBUG

#endif//_debug_h
