/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "SubtitleMPL2.h"
#include <iostream>
#include <fstream>
#include <glibmm/ustring.h>
#include "utility.h"
#include "RegEx.h"

/*
 *
 */
Glib::ustring SubtitleMPL2::get_name()
{
	return "MPL2";
}

/*
 *
 */
Glib::ustring SubtitleMPL2::get_extension()
{
	return "txt";
}

/*
 *
 */
bool SubtitleMPL2::check(const std::string &line)
{
	static RegEx ex("^\\[[0-9]+\\]\\[[0-9]+\\]");

	return ex.exec(line);
}


/*
 *
 */
SubtitleMPL2::SubtitleMPL2(Document* doc)
:SubtitleFormat(doc)
{
	se_debug(SE_DEBUG_LOADER | SE_DEBUG_SAVER);
}

/*
 *
 */
SubtitleMPL2::~SubtitleMPL2()
{
	se_debug(SE_DEBUG_LOADER | SE_DEBUG_SAVER);
}


/*
 *
 */
bool SubtitleMPL2::open(const Glib::ustring &filename, const Glib::ustring &encoding)
{
	se_debug(SE_DEBUG_LOADER);

	SubtitleFormat::open(filename, encoding);

	std::ifstream file(filename.c_str());
	if(!file)
	{
		throw SubtitleException("SubtitleMPL2", _("I can't open this file."));
	}

	unsigned int start=0, end=0;

	//double ds = SubtitleTime(0,0,0,100).totalmsecs;
	double ds = 100;
	
	std::string line;
	while(!file.eof() && std::getline(file, line))
	{
		if(sscanf(line.c_str(), "[%d][%d]", &start, &end) > 0)
		{
			std::string::size_type a = line.find(']');
			std::string::size_type b = line.find(']', a+1);
			
			std::string substr = line.substr(b+1, line.size());

			SubtitleModifier subtitle(m_subtitleModel->append());

			Glib::ustring text = check_end_char(charset_to_utf8(substr));

			characters_to_newline(text, "|");
		
			subtitle.set_text(text);
			subtitle.set_start_and_end(
					SubtitleTime((long int)(start*ds)),
					SubtitleTime((long int)(end*ds)));
		}
	}

	file.close();

	return true;
}

/*
 *
 */
bool SubtitleMPL2::save(const Glib::ustring &filename, const Glib::ustring &encoding)
{
	se_debug(SE_DEBUG_SAVER);

	SubtitleFormat::save(filename, encoding);
	
	std::ofstream file(filename.c_str());
	if(!file)
	{
		throw SubtitleException("SubtitleMPL2", _("I can't open this file."));
	}

	// TODO : change!
	double ds = 100;
	
	Glib::ustring text;
	
	Gtk::TreeNodeChildren rows = m_subtitleModel->children();
	for(Gtk::TreeIter it = rows.begin(); it; ++it)
	{
		SubtitleModifier subtitle(it);

		SubtitleTime start = subtitle.get_start();
		SubtitleTime end = subtitle.get_end();

		text = subtitle.get_text();

		newline_to_characters(text, "|");

		file << "["
			<< (unsigned int)(start.totalmsecs / ds)
			<< "]["
			<< (unsigned int)(end.totalmsecs / ds)
			<< "]"
			<< utf8_to_charset(text)
			<< std::endl;
	}
	
	file.close();

	return true;
}

